/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.launcher;

import org.flexunit.ant.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystem {
    WINDOWS,
    MACOSX,
    LINUX;

    private static final String SUN_WINDOWS = "windows";
    private static final String SUN_MACOSX = "mac os x";
    private static final String OPENJDK_MACOSX = "darwin";

    public static OperatingSystem identify() {
        OperatingSystem operatingSystem = null;
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith(SUN_WINDOWS)) {
            LoggingUtil.log("OS: [Windows]");
            operatingSystem = WINDOWS;
        } else if (string.contains(SUN_MACOSX) || string.contains(OPENJDK_MACOSX)) {
            LoggingUtil.log("OS: [Mac]");
            operatingSystem = MACOSX;
        } else {
            LoggingUtil.log("OS: [Linux]");
            operatingSystem = LINUX;
        }
        return operatingSystem;
    }
}

