<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>mod_proxy - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body>
<div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Modules</a></div>
<div id="page-content">
<div id="preamble"><h1>Module Apache mod_proxy</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_proxy.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>
<table class="module"><tr><th><a href="module-dict.html#Description">Description:</a></th><td>Serveur mandataire/passerelle multi-protocole</td></tr>
<tr><th><a href="module-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="module-dict.html#ModuleIdentifier">IdentificateurdeModule:</a></th><td>proxy_module</td></tr>
<tr><th><a href="module-dict.html#SourceFile">FichierSource:</a></th><td>mod_proxy.c</td></tr></table>
<h3>Sommaire</h3>

    <div class="warning"><h3>Avertissement</h3>
      <p>N'activez pas la fonctionnalit de mandataire avec la directive
      <code class="directive"><a href="#proxyrequests">ProxyRequests</a></code> avant
      d'avoir <a href="#access">scuris votre serveur</a>. Les serveurs
      mandataires ouverts sont dangereux pour votre rseau,
      mais aussi pour l'Internet au sens large.</p>
    </div>

    <p><code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> et ses modules associs implmentent
    un mandataire/passerelle pour le serveur HTTP Apache, et supportent
    de nombreux protocoles courants, ainsi que plusieurs algorithmes de
    rpartition de charge. Le support de protocoles et d'algorithmes de
    rpartition de charge supplmentaires peut tre assur par des
    modules tiers.</p>

    <p>Un jeu de modules chargs dans le serveur permet de fournir les
    fonctionnalits souhaites. Ces modules peuvent tre inclus
    statiquement  la compilation, ou dynamiquement via la directive
    <code class="directive"><a href="../mod/mod_so.html#loadmodule">LoadModule</a></code>. Ce jeu de module
    doit comporter :</p>

    <ul>
      <li><code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code>, qui fournit les fonctionnalits de
      base d'un mandataire</li>

      <li><code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> et un ou plusieurs modules
      de rpartition, si la rpartition de charge doit tre mise en
      oeuvre (Voir la documentation de
      <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> pour plus de dtails).</li>

      <li>un ou plusieurs modules de types de mandataire, ou protocoles
      :

        <table class="bordered">
        <tr><th>Protocole</th><th>Module</th></tr>
        <tr><td>AJP13 (Protocole Apache JServe version
          1.3)</td><td><code class="module"><a href="../mod/mod_proxy_ajp.html">mod_proxy_ajp</a></code></td></tr>
        <tr><td>CONNECT (pour
          SSL)</td><td><code class="module"><a href="../mod/mod_proxy_connect.html">mod_proxy_connect</a></code></td></tr>
        <tr><td>FastCGI</td><td><code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code></td></tr>
        <tr><td>ftp</td><td><code class="module"><a href="../mod/mod_proxy_ftp.html">mod_proxy_ftp</a></code></td></tr>
        <tr><td>HTTP/0.9, HTTP/1.0, et
          HTTP/1.1</td><td><code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code></td></tr>
        <tr><td>SCGI</td><td><code class="module"><a href="../mod/mod_proxy_scgi.html">mod_proxy_scgi</a></code></td></tr>
	<tr><td>WS and WSS (Web-sockets)</td><td><code class="module"><a href="../mod/mod_proxy_wstunnel.html">mod_proxy_wstunnel</a></code></td></tr>
        </table>
      </li>
    </ul>

    <p>En outre, d'autres modules fournissent des fonctionnalits
    tendues. <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code> et ses modules associs
    fournissent la mise en cache. Les directives <code>SSLProxy*</code>
    du module <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> permettent de contacter des
    serveurs distants en utilisant le protocole SSL/TLS. Ces modules
    additionnels devront tre chargs et configurs pour pouvoir
    disposer de ces fonctionnalits.</p>
</div>
<div id="quickview"><h3 class="directives">Directives</h3>
<ul id="toc">
<li><img alt="" src="../images/down.gif" /> <a href="#balancergrowth">BalancerGrowth</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#balancerinherit">BalancerInherit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#balancermember">BalancerMember</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#balancerpersist">BalancerPersist</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#noproxy">NoProxy</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxy">&lt;Proxy&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyaddheaders">ProxyAddHeaders</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxybadheader">ProxyBadHeader</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyblock">ProxyBlock</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxydomain">ProxyDomain</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyerroroverride">ProxyErrorOverride</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyiobuffersize">ProxyIOBufferSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxymatch">&lt;ProxyMatch&gt;</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxymaxforwards">ProxyMaxForwards</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypass">ProxyPass</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypassinherit">ProxyPassInherit</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypassinterpolateenv">ProxyPassInterpolateEnv</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypassmatch">ProxyPassMatch</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypassreverse">ProxyPassReverse</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypassreversecookiedomain">ProxyPassReverseCookieDomain</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypassreversecookiepath">ProxyPassReverseCookiePath</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxypreservehost">ProxyPreserveHost</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyreceivebuffersize">ProxyReceiveBufferSize</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyremote">ProxyRemote</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyremotematch">ProxyRemoteMatch</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyrequests">ProxyRequests</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyset">ProxySet</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxysourceaddress">ProxySourceAddress</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxystatus">ProxyStatus</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxytimeout">ProxyTimeout</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#proxyvia">ProxyVia</a></li>
</ul>
<h3>Sujets</h3>
<ul id="topics">
<li><img alt="" src="../images/down.gif" /> <a href="#forwardreverse">Mandataires directs et
    mandataires/passerelles inverses</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#examples">Exemples simples</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#handler">Accs via un gestionnaire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#workers">Workers</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#access">Contrler l'accs  votre
    mandataire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#startup">Ralentissement au dmarrage</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#intranet">Mandataire en Intranet</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#envsettings">Ajustements relatifs au
    protocole</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#request-bodies">Corps de requtes</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#x-headers">En-ttes de requte du mandataire
    inverse</a></li>
</ul><h3>Voir aussi</h3>
<ul class="seealso">
<li><code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_ajp.html">mod_proxy_ajp</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_connect.html">mod_proxy_connect</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_fcgi.html">mod_proxy_fcgi</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_ftp.html">mod_proxy_ftp</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_scgi.html">mod_proxy_scgi</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_wstunnel.html">mod_proxy_wstunnel</a></code></li>
<li><code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code></li>
<li><code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="forwardreverse" id="forwardreverse">Mandataires directs et
    mandataires/passerelles inverses</a></h2>
      <p>Le serveur HTTP Apache peut tre configur dans les deux modes mandataire
      <dfn>direct</dfn> et mandataire <dfn>inverse</dfn> (aussi nomm
      mode <dfn>passerelle</dfn>).</p>

      <p>Un <dfn>mandataire direct</dfn> standard est un serveur
      intermdiaire qui s'intercale entre le client et le <em>serveur
      demand</em>. Pour obtenir un contenu hberg par
      le serveur demand, le client envoie une requte au
      mandataire en nommant le serveur demand comme
      cible, puis le mandataire extrait le contenu depuis le
      serveur demand et le renvoie enfin au client. Le client doit tre
      configur de manire approprie pour pouvoir utiliser le mandataire
      direct afin d'accder  d'autres sites.</p>

      <p>L'accs  Internet depuis des clients situs derrire un
      pare-feu est une utilisation typique du mandataire direct. Le
      mandataire direct peut aussi utiliser la mise en cache (fournie
      par <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code>) pour rduire la charge du
      rseau.</p>

      <p>La fonctionnalit de mandataire direct est active via la
      directive <code class="directive"><a href="#proxyrequests">ProxyRequests</a></code>.
      Comme les mandataires directs permettent aux clients d'accder 
      des sites quelconques via votre serveur et de dissimuler leur
      vritable origine, il est indispensable de <a href="#access">scuriser votre serveur</a> de faon  ce que seuls
      les clients autoriss puissent accder  votre serveur avant
      d'activer la fonctionnalit de mandataire direct.</p>

      <p>Un <dfn>mandataire inverse</dfn> (ou <dfn>passerelle</dfn>),
      quant  lui, apparat au client comme un serveur web standard.
      Aucune configuration particulire du client n'est ncessaire. Le
      client adresse ses demandes de contenus ordinaires dans l'espace
      de nommage du mandataire inverse. Ce dernier dcide alors o
      envoyer ces requtes, et renvoie le contenu au client comme s'il
      l'hbergeait lui-mme.</p>

      <p>L'accs d'utilisateurs depuis Internet vers un serveur situ
      derrire un pare-feu est une utilisation typique du mandataire
      inverse. On peut aussi utiliser les mandataires inverses pour
      mettre en oeuvre une rpartition de charge entre plusieurs
      serveurs en arrire-plan, ou fournir un cache pour un serveur
      d'arrire-plan plus lent. Les mandataires inverses peuvent aussi
      tout simplement servir  rassembler plusieurs serveurs dans le
      mme espace de nommage d'URLs.</p>

      <p>La fonctionnalit de mandataire inverse est active via la
      directive <code class="directive"><a href="#proxypass">ProxyPass</a></code> ou
      le drapeau <code>[P]</code> de la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code>. Il n'est
      <strong>pas</strong> ncessaire de dfinir <code class="directive"><a href="#proxyrequests">ProxyRequests</a></code> pour configurer
      un mandataire inverse.</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="examples" id="examples">Exemples simples</a></h2>

    <p>Les exemples ci-dessous illustrent de manire trs basique la
    mise en oeuvre de la fonctionnalit de mandataire et ne sont l que
    pour vous aider  dmarrer. Reportez-vous  la documentation de
    chaque directive.</p>

    <p>Si en outre, vous dsirez activer la mise en cache, consultez la
    documentation de <code class="module"><a href="../mod/mod_cache.html">mod_cache</a></code>.</p>

    <div class="example"><h3>Mandataire inverse</h3><pre class="prettyprint lang-config">ProxyPass /foo http://foo.example.com/bar
ProxyPassReverse /foo http://foo.example.com/bar</pre>
</div>

    <div class="example"><h3>Mandataire direct</h3><pre class="prettyprint lang-config">ProxyRequests On
ProxyVia On

&lt;Proxy *&gt;
  Require host internal.example.com
&lt;/Proxy&gt;</pre>
</div>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="handler" id="handler">Accs via un gestionnaire</a></h2>

    <p>Vous pouvez aussi forcer le traitement d'une requte en tant que
    requte de mandataire inverse en crant un gestionnaire de transfert
    appropri. Dans l'exemple suivant, toutes les requtes pour
    des scripts PHP seront transmises au serveur FastCGI
    spcifi via un mandat inverse :
    </p>

    <div class="example"><h3>Scripts PHP et mandataire inverse</h3><pre class="prettyprint lang-config">&lt;FilesMatch \.php$&gt;
    SetHandler  "proxy:unix:/path/to/app.sock|fcgi://localhost/"
&lt;/FilesMatch&gt;</pre>
</div>

      <p>Cette fonctionnalit est disponible  partir de la version
      2.4.10 du serveur HTTP Apache.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="workers" id="workers">Workers</a></h2>
      <p>Le mandataire gre la configuration et les paramtres de
      communication des serveurs originaux au sein d'objets nomms
      <dfn>workers</dfn>. Deux types de worker sont fournis : le worker
      par dfaut du mandataire direct et le worker par dfaut du
      mandataire inverse. Il est aussi possible de dfinir explicitement
      des workers supplmentaires.</p>

      <p>Les deux workers par dfaut possdent une configuration fige
      et seront utiliss si aucun autre worker ne correspond  la
      requte. Ils n'utilisent ni les jeux de connexions (connection
      pooling), ni les
      connexions HTTP persistantes (Keep-Alive). En effet, les
      connexions TCP vers le serveur original sont fermes et ouvertes
      pour chaque requte.</p>

      <p>Les workers dfinis explicitement sont identifis par leur URL.
      Ils sont en gnral dfinis via les directives <code class="directive"><a href="#proxypass">ProxyPass</a></code> ou <code class="directive"><a href="#proxypassmatch">ProxyPassMatch</a></code> lorsqu'on les
      utilise dans le cadre d'un mandataire inverse :</p>

      <div class="example"><pre class="prettyprint lang-config">ProxyPass /example http://backend.example.com connectiontimeout=5 timeout=30</pre>
</div>
      

      <p>Cette directive va crer un worker associ  l'URL du serveur
      original <code>http://backend.example.com</code>, et utilisant les
      valeurs de timeout donnes. Lorsqu'ils sont utiliss dans le cadre
      d'un mandataire direct, les workers sont en gnral dfinis via la
      directive <code class="directive"><a href="#proxyset">ProxySet</a></code>,</p>

      <div class="example"><pre class="prettyprint lang-config">ProxySet http://backend.example.com connectiontimeout=5 timeout=30</pre>
</div>
      

      <p>ou encore via les directives <code class="directive"><a href="#proxy">Proxy</a></code> et <code class="directive"><a href="#proxyset">ProxySet</a></code> :</p>

      <pre class="prettyprint lang-config">&lt;Proxy http://backend.example.com&gt;
  ProxySet connectiontimeout=5 timeout=30
&lt;/Proxy&gt;</pre>


      <p>L'utilisation de workers dfinis explicitement dans le mode
      mandataire direct n'est pas trs courante, car les mandataires
      directs communiquent en gnral avec de nombreux serveurs
      originaux. La cration explicite de workers pour certains serveurs
      originaux peut cependant s'avrer utile si ces serveurs sont
      trs souvent sollicits. A leur niveau, les workers explicitement
      dfinis ne possdent aucune notion de mandataire direct ou
      inverse. Ils encapsulent un concept de communication commun avec
      les serveurs originaux. Un worker cr via la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code> pour tre utilis dans le
      cadre d'un mandataire inverse sera aussi utilis dans le cadre
      d'un mandataire directe chaque fois que l'URL vers le serveur
      original correspondra  l'URL du worker, et vice versa.</p>

      <p>L'URL qui identifie un worker correspond  l'URL de son serveur
      original, y compris un ventuel chemin donn :</p>

      <pre class="prettyprint lang-config">ProxyPass /examples http://backend.example.com/examples
ProxyPass /docs http://backend.example.com/docs</pre>


      <p>Dans cet exemple, deux workers diffrents sont dfinis, chacun
      d'eux utilisant des configurations et jeux de connexions
      spars.</p>

      <div class="warning"><h3>Partage de workers</h3>
        <p>Le partage de workers intervient lorsque les URLs des workers
	s'entrecoupent, ce qui arrive lorsque l'URL d'un worker
	correspond au dbut de l'URL d'un autre worker dfini plus loin
	dans le fichier de configuration. Dans l'exemple suivant,</p>

        <pre class="prettyprint lang-config">ProxyPass /apps http://backend.example.com/ timeout=60
ProxyPass /examples http://backend.example.com/examples timeout=10</pre>


        <p>le second worker n'est pas vraiment cr. C'est le premier
	worker qui est en fait utilis. L'avantage de ceci rside dans
	le fait qu'il n'existe qu'un seul jeu de connexions, ces
	dernires tant donc rutilises plus souvent. Notez que tous
	les attributs de configuration dfinis explicitement pour le
	deuxime worker seront ignors, ce qui sera journalis en tant
	qu'avertissement. Ainsi, dans l'exemple ci-dessus, la valeur de
	timeout retenue pour l'URL <code>/exemples</code> sera
	<code>60</code>, et non <code>10</code> !</p>

        <p>Si vous voulez empcher le partage de workers, classez vos
	dfinitions de workers selon la longueur des URLs, de la plus
	longue  la plus courte. Si au contraire vous voulez favoriser
	ce partage, utilisez l'ordre de classement inverse. Voir aussi
	l'avertissement  propos de l'ordre de classement des directives
	<code class="directive"><a href="#proxypass">ProxyPass</a></code>.</p>

      </div> 

      <p>Les workers dfinis explicitement sont de deux sortes :
      <dfn>workers directs</dfn> et <dfn>workers de rpartition (de
      charge)</dfn>. Ils supportent de nombreux attributs de
      configuration importants dcrits dans la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code>. Ces mmes attributs
      peuvent aussi tre dfinis via la directive <code class="directive"><a href="#proxyset">ProxySet</a></code>.</p>

      <p>Le jeu d'options disponibles pour un worker direct dpend du
      protocole spcifi dans l'URL du serveur original. Les protocoles
      disponibles comprennent <code>ajp</code>, <code>fcgi</code>,
      <code>ftp</code>, <code>http</code> et <code>scgi</code>.</p>

      <p>Les workers de rpartition sont des workers virtuels qui
      utilisent les workers directs, connus comme faisant partie de leurs
      membres, pour le traitement effectif des requtes. Chaque
      rpartiteur peut comporter plusieurs membres. Lorsqu'il traite une
      requte, il choisit un de ses membres en fonction de l'algorithme
      de rpartition de charge dfini.</p>

      <p>Un worker de rpartition est cr si son URL de worker comporte
      <code>balancer</code> comme indicateur de protocole. L'URL du
      rpartiteur permet d'identifier de manire unique le worker de
      rpartition. La directive <code class="directive"><a href="#balancermember">BalancerMember</a></code> permet d'ajouter des
      membres au rpartiteur.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="access" id="access">Contrler l'accs  votre
    mandataire</a></h2>
      <p>Vous pouvez restreindre l'accs  votre mandataire via le bloc
      de contrle <code class="directive"><a href="#proxy">&lt;Proxy&gt;</a></code> comme dans
      l'exemple suivant :</p>

      <pre class="prettyprint lang-config">&lt;Proxy *&gt;
  Require ip 192.168.0
&lt;/Proxy&gt;</pre>


      <p>Pour plus de dtails sur les directives de contrle d'accs,
      voir la documentation du module
      <code class="module"><a href="../mod/mod_authz_host.html">mod_authz_host</a></code>.</p>

      <p>Restreindre l'accs de manire stricte est essentiel si vous
      mettez en oeuvre un mandataire direct (en dfinissant la directive
      <code class="directive"><a href="#proxyrequests">ProxyRequests</a></code>  "on").
      Dans le cas contraire, votre serveur pourrait tre utilis par
      n'importe quel client pour accder  des serveurs quelconques,
      tout en masquant sa vritable identit. Ceci reprsente un danger
      non seulement pour votre rseau, mais aussi pour l'Internet au
      sens large. Dans le cas de la mise en oeuvre d'un mandataire
      inverse (en utilisant la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code> avec <code>ProxyRequests Off</code>), le contrle
      d'accs est moins critique car les clients ne peuvent contacter
      que les serveurs que vous avez spcifis.</p>

      <p><strong>Voir aussi</strong> la variable d'environnement <a href="mod_proxy_http.html#env">Proxy-Chain-Auth</a>.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="startup" id="startup">Ralentissement au dmarrage</a></h2>
      <p>Si vous utilisez la directive <code class="directive"><a href="#proxyblock">ProxyBlock</a></code>, les noms d'htes sont rsolus en adresses
      IP puis ces dernires mises en cache au cours du dmarrage
       des fins de tests de comparaisons ultrieurs. Ce processus peut
      durer plusieurs secondes (ou d'avantage) en fonction de la vitesse
       laquelle s'effectue la rsolution des noms d'htes.</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="intranet" id="intranet">Mandataire en Intranet</a></h2>
      <p>Un serveur mandataire Apache httpd situ  l'intrieur d'un Intranet
      doit faire suivre les requtes destines  un serveur externe 
      travers le pare-feu de l'entreprise (pour ce faire, dfinissez la
      directive <code class="directive"><a href="#proxyremote">ProxyRemote</a></code> de
      faon  ce qu'elle fasse suivre le <var>protocole</var> concern
      vers le mandataire du pare-feu). Cependant, lorsqu'il doit accder
       des ressources situes dans l'Intranet, il peut se passer du
      pare-feu pour accder aux serveurs. A cet effet, la directive
      <code class="directive"><a href="#noproxy">NoProxy</a></code> permet de
      spcifier quels htes appartiennent  l'Intranet et peuvent donc
      tre accds directement.</p>

      <p>Les utilisateurs d'un Intranet ont tendance  oublier le nom du
      domaine local dans leurs requtes WWW, et demandent par exemple
      "http://un-serveur/" au lieu de
      <code>http://un-serveur.example.com/</code>. Certains serveurs
      mandataires commerciaux acceptent ce genre de requte et les
      traitent simplement en utilisant un nom de domaine local
      implicite. Lorsque la directive <code class="directive"><a href="#proxydomain">ProxyDomain</a></code> est utilise et si le
      serveur est <a href="#proxyrequests">configur comme
      mandataire</a>, Apache httpd peut renvoyer une rponse de redirection et
      ainsi fournir au client l'adresse de serveur correcte,
      entirement qualifie. C'est la mthode  privilgier car le
      fichier des marque-pages de l'utilisateur contiendra alors des
      noms de serveurs entirement qualifis.</p>
    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="envsettings" id="envsettings">Ajustements relatifs au
    protocole</a></h2>
      <p>Pour les cas o <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> envoie des requtes
      vers un serveur qui n'implmente pas correctement les connexions
      persistantes ou le protocole HTTP/1.1, il existe deux variables
      d'environnement qui permettent de forcer les requtes  utiliser
      le protocole HTTP/1.0 avec connexions non persistantes. Elles
      peuvent tre dfinies via la directive <code class="directive"><a href="../mod/mod_env.html#setenv">SetEnv</a></code>.</p>

      <p>Il s'agit des variables <code>force-proxy-request-1.0</code> et
      <code>proxy-nokeepalive</code>.</p>

      <pre class="prettyprint lang-config">&lt;Location /buggyappserver/&gt;
  ProxyPass http://buggyappserver:7001/foo/
  SetEnv force-proxy-request-1.0 1
  SetEnv proxy-nokeepalive 1
&lt;/Location&gt;</pre>


    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="request-bodies" id="request-bodies">Corps de requtes</a></h2>

    <p>Certaines mthodes de requtes comme POST comportent un corps de
    requte. Le protocole HTTP stipule que les requtes qui comportent
    un corps doivent soit utiliser un codage de transmission
    fractionne (chunked transfer encoding), soit envoyer un en-tte de requte
    <code>Content-Length</code>. Lorsqu'il fait suivre ce genre de
    requte vers le serveur demand, <code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code>
    s'efforce toujours d'envoyer l'en-tte <code>Content-Length</code>.
    Par contre, si la taille du corps est importante, et si la requte
    originale utilise un codage  fractionnement, ce dernier peut aussi
    tre utilis dans la requte montante. Ce comportement peut tre
    contrl  l'aide de <a href="../env.html">variables
    d'environnement</a>. Ainsi, si elle est dfinie, la variable
    <code>proxy-sendcl</code> assure une compatibilit maximale avec les
    serveurs demands en imposant l'envoi de l'en-tte
    <code>Content-Length</code>, alors que
    <code>proxy-sendchunked</code> diminue la consommation de ressources
    en imposant l'utilisation d'un codage  fractionnement.</p>

    <p>Dans certaines circonstances, le serveur doit mettre en file
    d'attente sur disque les corps de requtes afin de satisfaire le
    traitement demand des corps de requtes. Par exemple, cette mise en
    file d'attente se produira si le corps original a t envoy selon un
    codage morcel (et possde une taille importante), alors que
    l'administrateur a demand que les requtes du serveur
    d'arrire-plan soient envoyes avec l'en-tte Content-Length ou en
    HTTP/1.0. Cette mise en file d'attente se produira aussi si le corps
    de la requte contient dj un en-tte Content-Length, alors que le
    serveur est configur pour filtrer les corps des requtes entrantes.</p>

    <p>La directive <code class="directive"><a href="../mod/core.html#limitrequestbody">LimitRequestBody</a></code> ne s'applique qu'aux
    corps de requtes que le serveur met en file d'attente sur disque.</p>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="x-headers" id="x-headers">En-ttes de requte du mandataire
    inverse</a></h2>

    <p>Lorsqu'il est configur en mode mandataire inverse (en utilisant
    par exemple la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code>),
    <code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code> ajoute plusieurs en-ttes de requte
    afin de transmettre des informations au serveur demand. Ces
    en-ttes sont les suivants :</p>

    <dl>
      <dt><code>X-Forwarded-For</code></dt>
      <dd>L'adresse IP du client.</dd>
      <dt><code>X-Forwarded-Host</code></dt>
      <dd>L'hte d'origine demand par le client dans l'en-tte de
      requte HTTP <code>Host</code>.</dd>
      <dt><code>X-Forwarded-Server</code></dt>
      <dd>Le nom d'hte du serveur mandataire.</dd>
    </dl>

    <p>Ces en-ttes doivent tre utiliss avec prcautions sur le
    serveur demand, car ils contiendront plus d'une valeur (spares
    par des virgules) si la requte originale contenait dj un de ces
    en-ttes. Par exemple, vous pouvez utiliser
    <code>%{X-Forwarded-For}i</code> dans la chane de format du journal
    du serveur demand pour enregistrer les adresses IP des clients
    originaux, mais il est possible que vous obteniez plusieurs adresses
    si la requte passe  travers plusieurs mandataires.</p>

    <p>Voir aussi les directives <code class="directive"><a href="#proxypreservehost">ProxyPreserveHost</a></code> et <code class="directive"><a href="#proxyvia">ProxyVia</a></code> directives, qui permettent
    de contrler d'autres en-ttes de requte.</p>

    <p>Note : Si vous devez ajouter des en-ttes particuliers  la
    requte mandate, utilisez la directive  <code class="directive"><a href="../mod/mod_headers.html#requestheader">RequestHeader</a></code>.</p>

   </div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="BalancerGrowth" id="BalancerGrowth">BalancerGrowth</a> <a name="balancergrowth" id="balancergrowth">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre de membres supplmentaires pouvant tre ajouts
aprs la configuration initiale</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BalancerGrowth <var>#</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BalancerGrowth 5</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>BalancerGrowth est disponible depuis la version 2.3.13 du
serveur HTTP Apache</td></tr>
</table>
    <p>Cette directive permet de dfinir le nombre de membres pouvant
    tre ajouts au groupe de rpartition de charge prconfigur d'un
    serveur virtuel. Elle n'est active que si le groupe a t
    prconfigur avec un membre au minimum.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="BalancerInherit" id="BalancerInherit">BalancerInherit</a> <a name="balancerinherit" id="balancerinherit">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Hritage des membres du groupes de rpartition de
    charge du mandataire dfinis au niveau du serveur principal</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BalancerInherit On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BalancerInherit On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.5 du serveur
    HTTP Apache.</td></tr>
</table>
        <p>Cette directive permet d'attribuer au serveur virtuel courant
	l'hritage des membres de groupes de rpartition de charge
	dfinis au niveau du serveur
	principal. Elle ne doit pas tre active si vous
	utilisez la fonctionnalit de modifications dynamiques du
	gestionnaire de rpartition de charge (Balancer Manager) pour
	viter des problmes et des comportements inattendus.</p>
        <p>Les dfinitions au niveau du serveur principal constituent
	les dfinitions par dfaut au niveau des serveurs virtuels.</p>
	
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="BalancerMember" id="BalancerMember">BalancerMember</a> <a name="balancermember" id="balancermember">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajoute un membre  un groupe de rpartition de
charge</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BalancerMember [<var>balancerurl</var>] <var>url</var> [<var>cl=valeur [cl=valeur ...]]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2 du serveur HTTP Apache.</td></tr>
</table>
    <p>Cette directive permet d'ajouter un membre  un groupe de
    rpartition de charge. Elle peut se trouver dans un conteneur
    <code>&lt;Proxy <var>balancer://</var>...&gt;</code>, et accepte
    tous les paramtres de paires cl/valeur que supporte la directive
    <code class="directive"><a href="#proxypass">ProxyPass</a></code>.</p>
    <p>La directive <code class="directive">BalancerMember</code> accepte un paramtre
    supplmentaire : <var>loadfactor</var>. Il s'agit du facteur de
    charge du membre - un nombre entre 1 (valeur par dfaut) et 100, qui
    dfinit la charge  appliquer au membre en question.</p>
    <p>L'argument <var>balancerurl</var> n'est requis que s'il ne se trouve pas
    dj dans la directive de conteneur <code>&lt;Proxy
    <var>balancer://</var>...&gt;</code>. Il correspond  l'URL d'un
    rpartiteur de charge dfini par une directive <code class="directive"><a href="#proxypass">ProxyPass</a></code>.</p>
    <p>La partie chemin de l'URL du rpartiteur dans toute directive de
    conteneur <code>&lt;Proxy <var>balancer://</var>...&gt;</code> est
    ignore.</p>
    <p>En particulier, le slash de fin de l'URL d'un
    <code class="directive">BalancerMember</code> doit tre supprim.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="BalancerPersist" id="BalancerPersist">BalancerPersist</a> <a name="balancerpersist" id="balancerpersist">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Tente de conserver les changements effectus par le
    gestionnaire de rpartition de charge aprs un redmarrage du
    serveur.</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>BalancerPersist On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>BalancerPersist Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>BalancerPersist n'est disponible qu' partir de la
    version 2.4.4 du serveur HTTP Apache.</td></tr>
</table>
        <p>Cette directive permet de conserver le contenu de l'espace
	mmoire partag associ aux rpartiteurs de charge et  leurs
	membres aprs un redmarrage du serveur. Ces modifications
	locales ne sont ainsi pas perdues lors des transitions d'tat
	dues  un redmarrage.</p>
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="NoProxy" id="NoProxy">NoProxy</a> <a name="noproxy" id="noproxy">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Serveurs, domaines ou rseaux auquels on se connectera
directement</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>NoProxy <var>domaine</var> [<var>domaine</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive n'a d'utilit que pour les serveurs mandataires
    Apache httpd au sein d'Intranets. La directive
    <code class="directive">NoProxy</code> permet de spcifier une liste de
    sous-rseaux, d'adresses IP, de serveurs et/ou de domaines spars
    par des espaces. Une requte pour un serveur qui correspond  un ou
    plusieurs critres sera toujours servie par ce serveur directement,
    sans tre redirige vers le(s) serveur(s) mandataire(s) dfini(s) par
    la directive <code class="directive"><a href="#proxyremote">ProxyRemote</a></code>.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ProxyRemote  *  http://firewall.example.com:81
NoProxy         .example.com 192.168.112.0/21</pre>
</div>

    <p>Le type des arguments <var>serveur</var> de la directive
    <code class="directive">NoProxy</code> appartiennent  la liste suivante
    :</p>

    <dl>
    
    <dt><var><a name="domain" id="domain">Domaine</a></var></dt>
    <dd>
    <p>Un <dfn>domaine</dfn> est ici un nom de domaine DNS partiellement
    qualifi prcd d'un point. Il reprsente une liste de serveurs qui
    appartiennent logiquement au mme domaine ou  la mme zonz DNS
    (en d'autres termes, les nom des serveurs se terminent tous par
    <var>domaine</var>).</p>

    <div class="example"><h3>Exemple</h3><p><code>
      .com .example.org.
    </code></p></div>

    <p>Pour faire la distinction entre <var>domaine</var>s et <var><a href="#hostname">nom d'hte</a></var>s (des points de vue  la fois
    syntaxique et
    smantique, un domaine DNS pouvant aussi avoir un enregistrement DNS
    de type A !), les <var>domaine</var>s sont toujours spcifis en les
    prfixant par un point.</p>

    <div class="note"><h3>Note</h3>
      <p>Les comparaisons de noms de domaines s'effectuent sans tenir
      compte de la casse, et les parties droites des <var>Domaine</var>s
      sont toujours censes correspondre  la racine de l'arborescence
      DNS, si bien que les domaines <code>.ExEmple.com</code> et
      <code>.example.com.</code> (notez le point  la fin du nom) sont
      considrs comme identiques. Comme une comparaison de domaines ne
      ncessite pas de recherche DNS, elle est beaucoup plus efficace
      qu'une comparaison de sous-rseaux.</p>
    </div></dd>

    
    <dt><var><a name="subnet" id="subnet">Sous-rseau</a></var></dt>
    <dd>
    <p>Un <dfn>Sous-rseau</dfn> est une adresse internet partiellement
    qualifie sous forme numrique (quatre nombres spars par des
    points), optionnellement suivie d'un slash et du masque de
    sous-rseau spcifiant le nombre de bits significatifs dans le
    <var>Sous-rseau</var>. Il reprsente un sous-rseau de serveurs qui
    peuvent tre atteints depuis la mme interface rseau. En l'absence
    de masque de sous-rseau explicite, il est sous-entendu que les
    digits manquants (ou caractres 0) de fin spcifient le masque de
    sous-rseau (Dans ce cas, le masque de sous-rseau ne peut tre
    qu'un multiple de 8). Voici quelques exemples :</p>

    <dl>
    <dt><code>192.168</code> ou <code>192.168.0.0</code></dt>
    <dd>le sous-rseau 192.168.0.0 avec un masque de sous-rseau
    implicite de 16 bits significatifs (parfois exprim sous la forme
    <code>255.255.0.0</code>)</dd>
    <dt><code>192.168.112.0/21</code></dt>
    <dd>le sous-rseau <code>192.168.112.0/21</code> avec un masque de
    sous-rseau implicite de 21 bits significatifs (parfois exprim
    sous la forme<code>255.255.248.0</code>)</dd>
    </dl>

    <p>Comme cas extrmes, un <em>Sous-rseau</em> avec un masque de
    sous-rseau de 32 bits significatifs est quivalent  une <var><a href="#ipaddr">adresse IP</a></var>, alors qu'un <em>Sous-rseau</em> avec un masque de
    sous-rseau de 0 bit significatif (c'est  dire 0.0.0.0/0) est
    identique  la constante <var>_Default_</var>, et peut correspondre
     toute adresse IP.</p></dd>

    
    <dt><var><a name="ipaddr" id="ipaddr">Adresse IP</a></var></dt>
    <dd>
    <p>Une <dfn>Adresse IP</dfn> est une adresse internet pleinement
    qualifie sous forme numrique (quatre nombres spars par des
    points). En gnral, cette adresse reprsente un serveur, mais elle
    ne doit pas ncessairement correspondre  un nom de domaine DNS.</p>
    <div class="example"><h3>Exemple</h3><p><code>
      192.168.123.7
    </code></p></div>

    <div class="note"><h3>Note</h3>
      <p>Une <dfn>Adresse IP</dfn> ne ncessite pas de rsolution DNS,
      et peut ainsi s'avrer plus efficace quant aux performances
      d'Apache.</p>
    </div></dd>

    
    <dt><var><a name="hostname" id="hostname">Nom de serveur</a></var></dt>
    <dd>
    <p>Un <dfn>Nom de serveur</dfn> est un nom de domaine DNS pleinement
    qualifi qui peut tre rsolu en une ou plusieurs adresses IP par le
    service de noms de domaines DNS. Il reprsente un hte logique (par
    opposition aux <var><a href="#domain">Domaine</a></var>s, voir
    ci-dessus), et doit pouvoir tre rsolu en une ou plusieurs <var><a href="#ipaddr">adresses IP</a></var> (ou souvent en une liste
    d'htes avec diffrentes <var><a href="#ipaddr">adresses
    IP</a></var>).</p>

    <div class="example"><h3>Exemples</h3><p><code>
      prep.ai.example.edu<br />
      www.example.org
    </code></p></div>

    <div class="note"><h3>Note</h3>
      <p>Dans de nombreuses situations, il est plus efficace de
      spcifier une <var><a href="#ipaddr">adresse IP</a></var> qu'un
      <var>Nom de serveur</var> car cela vite d'avoir  effectuer une
      recherche DNS. La rsolution de nom dans Apache httpd peut prendre un
      temps trs long lorsque la connexion avec le serveur de noms
      utilise une liaison PPP lente.</p>
      <p>Les comparaisons de <var>Nom de serveur</var> s'effectuent sans tenir
      compte de la casse, et les parties droites des <var>Noms de serveur</var>
      sont toujours censes correspondre  la racine de l'arborescence
      DNS, si bien que les domaines <code>WWW.ExEmple.com</code> et
      <code>www.example.com.</code> (notez le point  la fin du nom) sont
      considrs comme identiques.</p>
     </div></dd>
    </dl>

<h3>Voir aussi</h3>
<ul>
<li><a href="../dns-caveats.html">Problmes lis au DNS</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="Proxy" id="Proxy">&lt;Proxy&gt;</a> <a name="proxy" id="proxy">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Conteneur de directives s'appliquant  des ressources
mandates</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;Proxy <var>url-avec-jokers</var>&gt; ...&lt;/Proxy&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Les directives situes dans une section <code class="directive">&lt;Proxy&gt;</code> ne s'appliquent qu'au contenu
    mandat concern. Les jokers de style shell sont autoriss.</p>

    <p>Par exemple, les lignes suivantes n'autoriseront  accder  un
    contenu via votre serveur mandataire que les htes appartenant 
    <code>votre-reseau.example.com</code> :</p>

    <pre class="prettyprint lang-config">&lt;Proxy *&gt;
  Require host votre-reseau.example.com
&lt;/Proxy&gt;</pre>


    <p>Dans l'exemple suivant, tous les fichiers du rpertoire
    <code>foo</code> de <code>example.com</code> seront traits par le
    filtre <code>INCLUDES</code> lorsqu'ils seront envoys par
    l'intermdiaire du serveur mandataire :</p>

    <pre class="prettyprint lang-config">&lt;Proxy http://example.com/foo/*&gt;
  SetOutputFilter INCLUDES
&lt;/Proxy&gt;</pre>


    <div class="note"><h3>Diffrences avec la section de configuration Location</h3>
      <p>Une URL d'arrire-plan sera concerne par le conteneur Proxy si
      elle commence par la <var>url-avec-jokers</var>, mme si le
      dernier segment de chemin de la directive ne correspond qu' un
      prfixe de segment dee chemin de l'URL d'arrire-plan. Par exemple, &lt;Proxy
      http://example.com/foo&gt; correspondra entre autres aux URLs
      http://example.com/foo, http://example.com/foo/bar, et
      http://example.com/foobar. La correspondance de l'URL finale
      diffre du comportement de la section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> qui, pour le cas de cette note,
      traitera le segment de chemin final comme s'il se terminait par un
      slash.</p>
      <p>Pour un contrle plus fin de la correspondance des URL, voir la
      directive <code class="directive">&lt;ProxyMatch&gt;</code>.</p>
    </div>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#proxymatch">&lt;ProxyMatch&gt;</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyAddHeaders" id="ProxyAddHeaders">ProxyAddHeaders</a> <a name="proxyaddheaders" id="proxyaddheaders">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajoute des informations  propos du mandataire aux
en-ttes X-Forwarded-*</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyAddHeaders Off|On</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyAddHeaders On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.10</td></tr>
</table>
    <p>Cette directive permet de passer au serveur d'arrire-plan des
    informations  propos du mandataire via les en-ttes HTTP
    X-Forwarded-For, X-Forwarded-Host et X-Forwarded-Server.</p>
    <div class="note"><h3>Utilit</h3>
     <p>Cette option n'est utile que dans le cas du mandat HTTP trait
     par <code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code>.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyBadHeader" id="ProxyBadHeader">ProxyBadHeader</a> <a name="proxybadheader" id="proxybadheader">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine la manire de traiter les lignes d'en-tte
incorrectes d'une rponse</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyBadHeader IsError|Ignore|StartBody</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyBadHeader IsError</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>La directive <code class="directive">ProxyBadHeader</code> permet de
    dterminer le comportement de <code class="module"><a href="../mod/mod_proxy.html">mod_proxy</a></code> lorsqu'il
    reoit des lignes d'en-tte de rponse dont la syntaxe n'est pas valide (c'est
     dire ne contenant pas de caractre ':') en provenance du serveur
    original. Les arguments disponibles sont :</p>

    <dl>
    <dt><code>IsError</code></dt>
    <dd>Annule la requte et renvoie une rponse de code 502 (mauvaise
    passerelle). C'est le comportement par dfaut.</dd>

    <dt><code>Ignore</code></dt>
    <dd>Traite les lignes d'en-tte incorrectes comme si elles n'avaient
    pas t envoyes.</dd>

    <dt><code>StartBody</code></dt>
    <dd>A la rception de la premire ligne d'en-tte incorrecte, les
    autres en-ttes sont lus et ce qui reste est trait en tant que
    corps. Ceci facilite la prise en compte des serveurs d'arrire-plan
    bogus qui oublient d'insrer une ligne vide entre les
    en-ttes et le corps.</dd>
    </dl>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyBlock" id="ProxyBlock">ProxyBlock</a> <a name="proxyblock" id="proxyblock">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Termes, serveurs ou domaines bloqus par le
mandataire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyBlock *|<var>terme</var>|<var>serveur</var>|<var>domaine</var>
[<var>terme</var>|<var>serveur</var>|<var>domaine</var>] ...</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>La directive <code class="directive">ProxyBlock</code> permet de
    spcifier une liste de termes, serveurs et/ou domaines, spars par
    des espaces. Les requtes de documents HTTP, HTTPS, FTP vers des
    sites dont les noms contiennent des termes, noms de serveur ou
    domaine correspondants seront <em>bloqus</em> par le serveur
    mandataire. La module proxy va aussi tenter de dterminer les
    adresses IP des lments de la liste qui peuvent correspondre  des
    noms d'htes au cours du dmarrage, et les mettra en cache  des
    fins de comparaisons ultrieures. Ceci peut ralentir le dmarrage du
    serveur.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ProxyBlock news.example.com auctions.example.com friends.example.com</pre>
</div>

    <p>Notez qu'<code>example</code> suffirait aussi pour atteindre
    ces sites.</p>

    <p>Hosts conviendrait aussi s'il tait rfrenc par adresse IP.</p>

    <p>Notez aussi que</p>

    <pre class="prettyprint lang-config">ProxyBlock *</pre>


    <p>bloque les connexions vers tous les sites.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyDomain" id="ProxyDomain">ProxyDomain</a> <a name="proxydomain" id="proxydomain">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nom de domaine par dfaut pour les requtes
mandates</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyDomain <var>Domaine</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive n'a d'utilit que pour les serveurs mandataires
    Apache httpd au sein d'un Intranet. La directive
    <code class="directive">ProxyDomain</code> permet de spcifier le domaine
    par dfaut auquel le serveur mandataire apache appartient. Si le
    serveur reoit une requte pour un hte sans nom de domaine, il va
    gnrer une rponse de redirection vers le mme hte suffix par le
    <var>Domaine</var> spcifi.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">      ProxyRemote  *  http://firewall.example.com:81<br />
      NoProxy         .example.com 192.168.112.0/21<br />
      ProxyDomain     .example.com</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyErrorOverride" id="ProxyErrorOverride">ProxyErrorOverride</a> <a name="proxyerroroverride" id="proxyerroroverride">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Outrepasser les pages d'erreur pour les contenus
mandats</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyErrorOverride On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyErrorOverride Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive est utile pour les configurations de mandataires
    inverses, lorsque vous souhaitez que les pages d'erreur envoyes
    aux utilisateurs finaux prsentent un aspect homogne. Elle permet
    aussi l'inclusion de fichiers (via les SSI de
    <code class="module"><a href="../mod/mod_include.html">mod_include</a></code>) pour obtenir le code d'erreur et agir
    en consquence (le comportement par dfaut afficherait la page
    d'erreur du serveur mandat, alors que c'est le message d'erreur SSI
    qui sera affich si cette directive est  "on").</p>

    <p>Cette directive n'affecte pas le traitement des rponses
    informatives (1xx), de type succs normal (2xx), ou de redirection
    (3xx).</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyIOBufferSize" id="ProxyIOBufferSize">ProxyIOBufferSize</a> <a name="proxyiobuffersize" id="proxyiobuffersize">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dtermine la taille du tampon interne de transfert de
donnes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyIOBufferSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyIOBufferSize 8192</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>La directive <code class="directive">ProxyIOBufferSize</code> permet
    d'ajuster la taille du tampon interne utilis comme bloc-note pour
    les transferts de donnes entre entre et sortie. La taille minimale
    est de <code>512</code> octets.</p>

    <p>Dans la plupart des cas, il n'y a aucune raison de modifier cette
    valeur.</p>

    <p>Si elle est utilise avec AJP, cette directive permet de dfinir
    la taille maximale du paquet AJP en octets. Si la valeur spcifie
    est suprieure  65536, elle est corrige et prend la valeur 65536.
    Si vous ne conservez pas
    la valeur par dfaut, vous devez aussi modifier l'attribut
    <code>packetSize</code> de votre connecteur AJP du ct de Tomcat !
    L'attribut <code>packetSize</code> n'est disponible que dans Tomcat
    <code>5.5.20+</code> et <code>6.0.2+</code>.</p>
    <p>Il n'est normalement pas ncessaire de modifier la taille
    maximale du paquet. Des problmes ont cependant t rapports avec
    la valeur par dfaut lors de l'envoi de certificats ou de chanes de
    certificats.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyMatch" id="ProxyMatch">&lt;ProxyMatch&gt;</a> <a name="proxymatch" id="proxymatch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Conteneur de directives s'appliquant  des ressources
mandates correspondant  une expression rationnelle</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>&lt;ProxyMatch <var>regex</var>&gt; ...&lt;/ProxyMatch&gt;</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>La directive <code class="directive">&lt;ProxyMatch&gt;</code> est
    identique  la directive <code class="directive"><a href="#proxy">&lt;Proxy&gt;</a></code>,  l'exception qu'elle dfinit
    les URLs auxquelles elle s'applique en utilisant une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression rationnelle</a>.</p>

    <p>A partir de la version 2.4.8, les groupes nomms et les
    rfrences arrires sont extraits et enregistrs dans
    l'environnement avec leur nom en majuscules et prfix par "MATCH_". Ceci permet
    de rfrencer des URLs dans des <a href="../expr.html">expressions</a>
    ou au sein de modules comme <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Pour
    viter toute confusion, les rfrences arrires numrotes (non
    nommes) sont ignores. Vous devez utiliser  la place des groupes
    nomms.</p>

<pre class="prettyprint lang-config">&lt;ProxyMatch ^http://(?&lt;sitename&gt;[^/]+)&gt;
    Require ldap-group cn=%{env:MATCH_SITENAME},ou=combined,o=Example
&lt;/ProxyMatch&gt;</pre>


<h3>Voir aussi</h3>
<ul>
<li><code class="directive"><a href="#proxy">&lt;Proxy&gt;</a></code></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyMaxForwards" id="ProxyMaxForwards">ProxyMaxForwards</a> <a name="proxymaxforwards" id="proxymaxforwards">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Nombre maximum de mandataires  travers lesquelles une
requte peut tre redirige</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyMaxForwards <var>nombre</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyMaxForwards -1</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Comportement par dfaut
modifi dans 2.2.7</td></tr>
</table>
    <p>La directive <code class="directive">ProxyMaxForwards</code> permet de
    spcifier le nombre maximum de mandataires  travers lesquels une
    requte peut passer dans le cas o la la requte ne contient pas
    d'en-tte <code>Max-Forwards</code>. Ceci permet de se prmunir
    contre les boucles infinies de mandataires ou contre les attaques de
    type dni de service.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ProxyMaxForwards 15</pre>
</div>

    <p>Notez que la dfinition de la directive
    <code class="directive">ProxyMaxForwards</code> constitue une violation du
    protocole HTTP/1.1 (RFC2616), qui interdit  un mandataire de
    dfinir <code>Max-Forwards</code> si le client ne l'a pas fait
    lui-mme. Les versions prcdentes d'Apache httpd la dfinissaient
    systmatiquement. Une valeur ngative de
    <code class="directive">ProxyMaxForwards</code>, y compris la valeur par
    dfaut -1, implique un comportement compatible avec le protocole,
    mais vous expose aux bouclages infinis.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPass" id="ProxyPass">ProxyPass</a> <a name="proxypass" id="proxypass">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Rfrencer des serveurs distants depuis
l'espace d'URLs du serveur local</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPass [<var>chemin</var>] !|<var>url</var> [<var>cl=valeur</var>
  <var>[cl=valeur</var> ...]] [nocanon] [interpolate] [noquery]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive permet de rfrencer des serveurs distants depuis
    l'espace d'URLs du serveur local ; le serveur
    local n'agit pas en tant que mandataire au sens conventionnel, mais
    plutt comme miroir du serveur distant. Le serveur local est
    souvent nomm <dfn>mandataire inverse</dfn> ou
    <dfn>passerelle</dfn>. L'argument <var>chemin</var> est le nom d'un
    chemin virtuel local ; <var>url</var> est une URL partielle pour le
    serveur distant et ne doit pas contenir de chane d'arguments.</p>

    <div class="note"><strong>Note : </strong>Cette directive ne peut pas tre
    utilise dans un contexte de niveau rpertoire.</div>

    <div class="warning">En gnral, la directive <code class="directive"><a href="#proxyrequests">ProxyRequests</a></code> doit tre dfinie 
    <strong>off</strong> lorsqu'on utilise la directive
    <code class="directive">ProxyPass</code>.</div>

    <p>Le support des sockets de style Unix est fourni ; il suffit pour
    cela d'utiliser une URL cible prfixe par
    <code>unix:/path/lis.sock|</code>. Par exemple, pour mandater HTTP
    et cibler l'UDS /home/www/socket, vous devez utiliser
    <code>unix:/home/www.socket|http://localhost/whatever/</code>.</p>

    <div class="note"><strong>Note :</strong>Le chemin associ  l'URL
    <code>unix:</code> tient compte de la directive
    <code class="directive">DefaultRuntimeDir</code>.</div>

    <p>Supposons que le serveur local a pour adresse
    <code>http://example.com/</code> ; alors la ligne</p>

    <pre class="prettyprint lang-config">&lt;Location /mirror/foo/&gt;
    ProxyPass http://backend.example.com/
&lt;/Location&gt;</pre>


    <p>va convertir en interne toute requte pour
    <code>http://example.com/miroir/foo/bar</code> en une requte
    mandate pour <code>http://backend.example.com/bar</code>.</p>

    <p>La syntaxe alternative suivante est valide, bien qu'elle puisse
    induire une dgradation des performances lorsqu'elle est
    prsente en trs grand nombre. Elle possde l'avantage de
    permettre un contrle dynamique via l'interface <a href="mod_proxy_balancer.html#balancer_manager">Balancer Manager</a> :</p>

    <pre class="prettyprint lang-config">ProxyPass /miroir/foo/ http://backend.example.com/</pre>


    <div class="warning">
    <p>Si le premier argument se termine par un slash
    <strong>/</strong>, il doit en tre de mme pour le second argument
    et vice versa. Dans le cas contraire, il risque de manquer des
    slashes ncessaires dans la requte rsultante vers le serveur
    d'arrire-plan et les rsulats ne seront pas ceux attendus.
    </p>
    </div>

    <p>Le drapeau <code>!</code> permet de soustraire un sous-rpertoire
    du mandat inverse, comme dans l'exemple suivant :</p>

    <pre class="prettyprint lang-config">&lt;Location /mirror/foo/&gt;
    ProxyPass http://backend.example.com/
&lt;/Location&gt;
&lt;Location /mirror/foo/i&gt;
    ProxyPass !
&lt;/Location&gt;</pre>


    <pre class="prettyprint lang-config">ProxyPass /mirror/foo/i !
ProxyPass /mirror/foo http://backend.example.com</pre>


    <p>va mandater toutes les requtes pour <code>/miroir/foo</code>
    vers <code>backend.example.com</code>, <em>sauf</em> les requtes
    pour <code>/miroir/foo/i</code>.</p>

    <div class="warning"><h3>Ordre de classement des directives ProxyPass</h3>
      <p>Les directives <code class="directive"><a href="#proxypass">ProxyPass</a></code> et <code class="directive"><a href="#proxypassmatch">ProxyPassMatch</a></code> sont values dans
      l'ordre de leur apparition dans le fichier de configuration. La
      premire rgle qui correspond s'applique. Vous devez donc en
      gnral classer les rgles <code class="directive"><a href="#proxypass">ProxyPass</a></code> qui entrent en conflit de
      l'URL la plus longue  la plus courte. Dans le cas contraire, les
      rgles situes aprs une rgle dont l'URL correspond au dbut de
      leur propre URL seront ignores. Notez que tout ceci est en
      relation avec le partage de workers. Par contre, on ne peut placer
      qu'une seule directive <code class="directive"><a href="#proxypass">ProxyPass</a></code> dans une section
      <code class="directive"><a href="../mod/core.html#location">Location</a></code>, et c'est la section
      la plus spcifique qui l'emportera.</p>

      <p>Pour les mmes raisons, les exclusions doivent se situer
      <em>avant</em> les directives <code class="directive">ProxyPass</code>
      gnrales.</p>

    </div> 

    <p>Depuis la version 2.1 du serveur HTTP Apache, mod_proxy supporte
    les groupements de connexions vers un serveur d'arrire-plan. Les
    connexions cres  la demande peuvent tre enregistres dans un
    groupement pour une utilisation ultrieure. La taille du groupe
    ainsi que d'autres caractristiques peuvent tre dfinies via la
    directive <code class="directive">ProxyPass</code> au moyen de paramtres
    <code>cl=valeur</code> dont la description fait l'objet du tableau
    ci-dessous.</p>

    <p>Par dfaut, mod_proxy permet et met en rserve le nombre maximum
    de connexions pouvant tre utilises simultanment par le processus
    enfant concern du serveur web. Le paramtre <code>max</code> permet
    de rduire cette valeur par dfaut. Le paramtre <code>ttl</code>,
    quant  lui, permet de dfinir une dure de vie optionnelle ; les
    connexions qui n'ont pas t utilises pendant au moins
    <code>ttl</code> secondes seront fermes. <code>ttl</code> permet
    aussi d'empcher l'utilisation d'une connexion susceptible d'tre
    ferme suite  une fin de vie de connexion persistante sur le
    serveur d'arrire-plan.</p>

    <p>Le groupement de connexions est maintenu au niveau de chaque
    processus enfant du serveur web, et <code>max</code>, ainsi que les
    autres paramtres, ne font
    l'objet d'aucune coordination entre les diffrents processus
    enfants, sauf si un seul processus enfant est autoris par la
    configuration ou la conception du module multi-processus (MPM).</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ProxyPass /example http://backend.example.com max=20 ttl=120 retry=300</pre>
</div>

    <table class="bordered"><tr><th>Paramtres de BalancerMember</th></tr></table>
    <table>
    <tr><th>Paramtre</th>
        <th>Dfaut</th>
        <th>Description</th></tr>
    <tr><td>min</td>
        <td>0</td>
        <td>Nombre minimum d'entres dans le pool de connexions,
	distinct du nombre de connexions effectif. La valeur par dfaut
	ne doit tre modifie que dans des circonstances particulires
	o la mmoire associe aux connexions avec le serveur
	d'arrire-plan doit tre pralloue ou rserve dans le tas.</td></tr>
    <tr><td>max</td>
        <td>1...n</td>
        <td>Nombre maximum de connexions autorises vers le serveur
	d'arrire-plan. La valeur par dfaut correspond au nombre de
	threads par processus pour le MPM (Module Multi Processus)
	actif. La valeur sera toujours 1 pour le MPM Prefork, alors
	qu'elle dpendra de la dfinition de la directive
	<code class="directive">ThreadsPerChild</code> pour les autres MPMs.</td></tr>
    <tr><td>smax</td>
        <td>max</td>
        <td>Les entres du pool de connexions conserves au del de
	cette limite sont libres au cours de certaines oprations si
	elles n'ont pas t utilises au cours de leur dure de vie,
	dfinie par le paramtre <code>ttl</code>. Si l'entre du pool
	de connexions est associe  une connexion, cette dernire sera
	ferme. La valeur par dfaut ne doit tre modifie que dans des
	circonstances particulires o les entres du pool de connexions
	et toutes connexions associes qui ont dpass leur dure de vie
	doivent tre libres ou fermes de manire plus autoritaire.</td></tr>
    <tr><td>acquire</td>
        <td>-</td>
        <td>Cette cl permet de dfinir le dlai maximum d'attente pour
	une connexion libre dans le jeu de connexions, en millisecondes.
	S'il n'y a pas de connexion libre dans le jeu, Apache httpd renverra
	l'tat <code>SERVER_BUSY</code> au client.
    </td></tr>
    <tr><td>connectiontimeout</td>
        <td>timeout</td>
        <td>Dlai d'attente d'une connexion en secondes.
        La dure en secondes pendant laquelle Apache httpd va attendre pour
	l'tablissement d'une connexion vers le serveur d'arrire-plan.
	Le dlai peut tre spcifi en millisecondes en ajoutant le
	suffixe ms.
    </td></tr>
    <tr><td>disablereuse</td>
        <td>Off</td>
        <td>Vous pouvez utiliser cette cl pour forcer mod_proxy 
	fermer immdiatement une connexion vers le serveur
	d'arrire-plan aprs utilisation, et ainsi dsactiver le jeu de
	connexions permanentes vers ce serveur. Ceci peut s'avrer utile
	dans des situations o un pare-feu situ entre Apache httpd et le
	serveur d'arrire-plan (quelque soit le protocole) interrompt
	des connexions de manire silencieuse, ou lorsque le serveur
	d'arrire-plan lui-mme est accessible par rotation de DNS
	(round-robin DNS). Pour dsactiver la rutilisation du jeu de
	connexions, dfinissez cette cl  <code>On</code>.
    </td></tr>
    <tr><td>flushpackets</td>
        <td>off</td>
        <td>Permet de dfinir si le module mandataire doit vider
	automatiquement le tampon de sortie aprs chaque tronon de
	donnes. 'off' signifie que le tampon sera vid si ncessaire,
	'on' que le tampon sera vid aprs chaque envoi d'un
	tronon de donnes, et 'auto' que le tampon sera vid aprs un
	dlai de 'flushwait' millisecondes si aucune entre n'est reue.
	Actuellement, cette cl n'est supporte que par AJP.
    </td></tr>
    <tr><td>flushwait</td>
        <td>10</td>
        <td>Le dlai d'attente pour une entre additionnelle, en
	millisecondes, avant le vidage du tampon en sortie dans le cas
	o 'flushpackets' est  'auto'.
    </td></tr>
    <tr><td>iobuffersize</td>
        <td>8192</td>
        <td>Permet de dfinir la taille du tampon d'entres/sorties du
	bloc-notes interne. Cette cl vous permet d'outrepasser la
	directive <code class="directive">ProxyIOBufferSize</code> pour un
	serveur cible spcifique. La valeur doit tre au minimum 512 ou dfinie
	 0 pour la valeur par dfaut du systme de 8192.
    </td></tr>
    <tr><td>keepalive</td>
        <td>Off</td>
        <td><p>Cette cl doit tre utilise lorsque vous avez un pare-feu
	entre Apache httpd et le serveur d'arrire-plan, et si ce dernier tend
	 interrompre les connexions inactives. Cette cl va faire en
	sorte que le systme d'exploitation envoie des messages
	<code>KEEP_ALIVE</code> sur chacune des connexions inactives et
	ainsi viter la	fermeture de la	connexion par le pare-feu.
	Pour conserver les connexions persistantes, definissez cette
	proprit  <code>On</code>.</p>
    <p>La frquence de vrification des connexions TCP persistantes
    initiale et subsquentes dpend de la configuration globale de l'OS,
    et peut atteindre 2 heures. Pour tre utile, la frquence configure
    dans l'OS doit tre infrieure au seuil utilis par le pare-feu.</p>

    </td></tr>
    <tr><td>lbset</td>
        <td>0</td>
        <td>Dfinit le groupe de rpartition de charge dont le serveur cible
	est membre. Le rpartiteur de charge va essayer tous les membres
	d'un groupe de rpartition de charge de numro infrieur avant
	d'essayer ceux dont le groupe possde un numro suprieur.
    </td></tr>
    <tr><td>ping</td>
        <td>0</td>
        <td>Avec la cl Ping, le serveur web va "tester" la connexion
	vers le serveur d'arrire-plan avant de transmettre la requte.
	Avec AJP, <code class="module"><a href="../mod/mod_proxy_ajp.html">mod_proxy_ajp</a></code> envoie une requte
	<code>CPING</code> sur la connexion ajp13 (implment sur Tomcat
	3.3.2+, 4.1.28+ et 5.0.13+). Avec HTTP,
	<code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code> envoie <code>100-Continue</code>
	au serveur d'arrire-plan (seulement avecHTTP/1.1 - pour les
	serveurs d'arrire-plan non HTTP/1.1, cette cl ne produit
	aucun effet). Dans les deux cas, ce paramtre correspond au
	dlai en secondes pour l'attente de la rponse. Cette
	fonctionnalit a t ajoute pour viter les problmes avec les
	serveurs d'arrire-plan bloqus ou surchargs.

	Le trafic
	rseau peut s'en trouver augment en fonctionnement normal, ce
	qui peut poser problme, mais peut s'en trouver diminu dans les
	cas o les noeuds de cluster sont arrts ou
	surchargs. Le dlai peut
	aussi tre dfini en millisecondes en ajoutant le suffixe
	ms.
    </td></tr>
    <tr><td>receivebuffersize</td>
        <td>0</td>
        <td>Dfinit la taille du tampon rseau explicite (TCP/IP) pour
	les connexions mandates. Cette cl vous permet d'outrepasser la
	directive <code class="directive">ProxyReceiveBufferSize</code> pour un
	serveur cible spcifique. Sa valeur doit tre au minimum 512 ou dfinie
	 0 pour la valeur par dfaut du systme.
    </td></tr>
    <tr><td>redirect</td>
        <td>-</td>
        <td>Route pour la redirection du serveur cible. Cette valeur est en
	gnral dfinie dynamiquement pour permettre une suppression
	scurise du noeud du cluster. Si cette cl est dfinie, toutes
	les requtes sans identifiant de session seront rediriges vers
	le membre de groupe de rpartition de charge dont la route
	correspond  la valeur de la cl.
    </td></tr>
    <tr><td>retry</td>
        <td>60</td>
        <td>Dlai entre deux essais du serveur cible du jeu de connexions en
	secondes. Si le serveur cible du jeu de connexions vers le serveur
	d'arrire-plan est dans un tat d'erreur, Apache httpd ne redirigera
	pas de requte vers ce serveur avant l'expiration du dlai
	spcifi. Ceci permet d'arrter le serveur d'arrire-plan pour
	maintenance, et de le remettre en ligne plus tard. Une valeur de
	0 implique de toujours essayer les serveurs cibles dans un tat d'erreur
	sans dlai.
    </td></tr>
    <tr><td>route</td>
        <td>-</td>
        <td>La route du serveur cible lorsqu'il est utilis au sein d'un
	rpartiteur de charge. La route est une valeur ajoute 
	l'identifiant de session.
    </td></tr>
    <tr><td>status</td>
        <td>-</td>
        <td>Valeur constitue d'une simple lettre et dfinissant l'tat
	initial de ce serveur cible.
	 <table>
         <tr><td>D: le serveur cible est dsactiv et n'accepte aucune requte.</td></tr>
         <tr><td>S: le serveur cible est arrt.</td></tr>
         <tr><td>I: le serveur cible est en mode "erreurs ignores",
	 et sera toujours considr comme disponible.</td></tr>
         <tr><td>H: le serveur cible est en mode d'attente et ne sera
	 utilis que si aucun autre serveur n'est disponible.</td></tr>
         <tr><td>E: le serveur cible est en erreur.</td></tr>
         <tr><td>N: le serveur cible est en mode vidage, n'acceptera que
	 les sessions persistantes qui lui appartiennent, et refusera
	 toutes les autres requtes.</td></tr>
        </table>
	Une valeur d'tat peut tre dfinie (ce qui
	correspond au comportement par dfaut) en prfixant la valeur
	par '+', ou annule en prfixant la valeur par '-'. Ainsi, la
	valeur 'S-E' dfinit l'tat de ce serveur cible  "arrt" et supprime
	le drapeau "en-erreur".
    </td></tr>
    <tr><td>timeout</td>
        <td><code class="directive"><a href="#proxytimeout">ProxyTimeout</a></code></td>
        <td>Dlai d'attente de la connexion en secondes. Le nombre de
	secondes pendant lesquelles Apache httpd attend l'envoi de
	donnes vers le serveur d'arrire-plan.
    </td></tr>
    <tr><td>ttl</td>
        <td>-</td>
        <td>Dure de vie des connexions inactives et des entres du pool
	de connexions associes en secondes. Une fois cette
	limite atteinte, une connexion ne sera pas rutilise ; elle
	sera ferme aprs un dlai variable.
    </td></tr>

    </table>

    <p>Si l'URL de la directive Proxy dbute par
    <code>balancer://</code> (par exemple:
    <code>balancer://cluster</code>, toute information relative au
    chemin est ignore), alors un serveur cible virtuel ne communiquant pas
    rellement avec le serveur d'arrire-plan sera cr. Celui-ci sera
    en fait responsable de la gestion de plusieurs serveurs cibles "rels". Dans
    ce cas, un jeu de paramtres particuliers s'applique  ce serveur cible
    virtuel. Voir <code class="module"><a href="../mod/mod_proxy_balancer.html">mod_proxy_balancer</a></code> pour plus
    d'informations  propos du fonctionnement du rpartiteur de
    charge.
    </p>
    <table class="bordered"><tr><th>Paramtres du rpartiteur</th></tr></table>
    <table>
    <tr><th>Paramtre</th>
        <th>Dfaut</th>
        <th>Description</th></tr>
    <tr><td>lbmethod</td>
        <td>byrequests</td>
        <td>Mthode de rpartition de charge utilise. Permet de
	slectionner la mthode de planification de la rpartition de
	charge  utiliser. La valeur est soit <code>byrequests</code>,
	pour effectuer un dcompte de requtes pondres, soit
	<code>bytraffic</code>, pour effectuer une rpartition en
	fonction du dcompte des octets transmis, soit
	<code>bybusyness</code>, pour effectuer une rpartition en
	fonction des requtes en attente. La valeur par dfaut est
	<code>byrequests</code>.
    </td></tr>
    <tr><td>maxattempts</td>
        <td>1 de moins que le nombre de workers, ou 1 avec un seul
	worker</td>
        <td>Nombre maximum d'checs avant abandon.
    </td></tr>
    <tr><td>nofailover</td>
        <td>Off</td>
        <td>Si ce paramtre est dfini  <code>On</code>, la session va
	s'interrompre si le serveur cible est dans un tat d'erreur ou
	dsactiv. Dfinissez ce paramtre  On si le serveur
	d'arrire-plan ne supporte pas la rplication de session.
    </td></tr>
    <tr><td>stickysession</td>
        <td>-</td>
        <td>Nom de session persistant du rpartiteur. La valeur est
	gnralement du style <code>JSESSIONID</code> ou
	<code>PHPSESSIONID</code>, et dpend du serveur d'application
	d'arrire-plan qui supporte les sessions. Si le serveur
	d'application d'arrire-plan utilise des noms diffrents pour
	les cookies et les identifiants cods d'URL (comme les
	conteneurs de servlet), sparez-les par le caractre '|'. La
	premire partie contient le cookie et la seconde le chemin.<br />
	Disponible depuis la version 2.4.4 du serveur HTTP Apache.
    </td></tr>
    <tr><td>stickysessionsep</td>
        <td>"."</td>
        <td>Dfinit le caractre de sparation dans le cookie de
	session. Certains serveurs d'application d'arrire-plan
	n'utilisent pas le caractre '.' comme sparateur. Par exemple
	le serveur Oracle Weblogic utilise le caractre '!'. Cette
	option permet d'attribuer au caractre de sparation la valeur
	approprie. Si elle est dfinie  'Off', aucun caractre de
	sparation n'est utilis.
    </td></tr>
    <tr><td>scolonpathdelim</td>
        <td>Off</td>
        <td>Si ce paramtre est dfini  <code>On</code>, le caractre
	';' sera utilis comme sparateur de chemin de session
	persistante additionnel. Ceci permet principalement de simuler
	le comportement de mod_jk lorsqu'on utilise des chemins du style
	<code>JSESSIONID=6736bcf34;foo=aabfa</code>.
    </td></tr>
    <tr><td>timeout</td>
        <td>0</td>
        <td>Dlai du rpartiteur en secondes. Si ce paramtre est
	dfini, sa valeur correspond  la dure maximale d'attente pour
	un serveur cible libre. Le comportement par dfaut est de ne pas
	attendre.
    </td></tr>
    <tr><td>failonstatus</td>
        <td>-</td>
        <td>Une liste de codes d'tat HTTP spars par des virgules. Si
	ce paramtre est prsent, le worker se mettra en erreur si le
	serveur d'arrire-plan renvoie un des codes d'tat spcifis
	dans la liste. La rcupration du worker s'effectue comme dans
	le cas des autres erreurs de worker.
    </td></tr>
    <tr><td>failontimeout</td>
        <td>Off</td>
        <td>Si ce paramtre est dfini  "On", un dlai d'attente
	dpass en entre/sortie aprs envoi d'une requte au serveur
	d'arrire-plan va mettre le processus en tat d'erreur. La
	sortie de cet tat d'erreur se passe de la mme faon que pour
	les autres erreurs.<br />
	Disponible  partir de la version 2.4.5 du serveur HTTP Apache.
    </td></tr>
    <tr><td>nonce</td>
        <td>&lt;auto&gt;</td>
        <td>Le nombre  usage unique de protection utilis dans la page
	de l'application <code>balancer-manager</code>. Par dfaut, la
	protection de la page est assure par un nombre  usage unique
	automatique  base d'UUID. Si une valeur est prcise, elle sera
	utilise comme nombre  usage unique. La valeur
	<code>None</code> dsactive la vrification du nombre  usage
	unique.
    <div class="note"><h3>Note</h3>
      <p>En plus du nombre  usage unique, la page de l'application
      <code>balancer-manager</code> peut tre protge par une ACL.</p>
    </div>
     </td></tr>
    <tr><td>growth</td>
        <td>0</td>
        <td>Nombre de membres supplmentaires que l'on peut ajouter  ce
	rpartiteur en plus de ceux dfinis au niveau de la
	configuration.
    </td></tr>
    <tr><td>forcerecovery</td>
        <td>On</td>
        <td>Force la relance immdiate de tous les membres sans tenir
	compte de leur paramtre retry dans le cas o ils sont tous en
	tat d'erreur. Il peut cependant arriver qu'un membre dj
	surcharg entre dans une situation critique si la relance de
	tous les membres est force sans tenir compte du paramtre retry
	de chaque membre. Dans ce cas, dfinissez ce paramtre 
	<code>Off</code>.<br />
	Disponible depuis la version 2.4.2 du serveur HTTP Apache.
    </td></tr>

    </table>
    <p>Exemple de configuration d'un rpartiteur de charge</p>
    <pre class="prettyprint lang-config">ProxyPass /special-area http://special.example.com smax=5 max=10
ProxyPass / balancer://mycluster/ stickysession=JSESSIONID|jsessionid nofailover=On
&lt;Proxy balancer://mycluster&gt;
    BalancerMember ajp://1.2.3.4:8009
    BalancerMember ajp://1.2.3.5:8009 loadfactor=20
    # Less powerful server, don't send as many requests there,
    BalancerMember ajp://1.2.3.6:8009 loadfactor=5
&lt;/Proxy&gt;</pre>


    <p>Configuration d'un serveur cible de rserve qui ne sera utilis que si
    aucun autre serveur cible n'est disponible</p>
    <pre class="prettyprint lang-config">ProxyPass / balancer://hotcluster/ 
&lt;Proxy balancer://hotcluster&gt;
    BalancerMember ajp://1.2.3.4:8009 loadfactor=1
    BalancerMember ajp://1.2.3.5:8009 loadfactor=2
    # The server below is on hot standby
    BalancerMember ajp://1.2.3.6:8009 status=+H
    ProxySet lbmethod=bytraffic
&lt;/Proxy&gt;</pre>


    <p>Normalement, mod_proxy va mettre sous leur forme canonique les
    URLs traites par ProxyPass. Mais ceci peut tre incompatible avec
    certains serveurs d'arrire-plan, et en particulier avec ceux qui
    utilisent <var>PATH_INFO</var>. Le mot-cl optionnel
    <var>nocanon</var> modifie ce comportement et permet de transmettre
    le chemin d'URL sous sa forme brute au serveur d'arrire-plan. Notez
    que ceci peut affecter la scurit de votre serveur d'arrire-plan,
    car la protection limite contre les attaques  base d'URL que
    fournit le mandataire est alors supprime.</p>

    <p>Par dfaut, mod_proxy inclut la chane de paramtres lors de la
    gnration de la variable d'environnement
    <var>SCRIPT_FILENAME</var>. Le mot-cl optionnel <var>noquery</var>
    (disponible  partir de la version 2.4.1) permet d'exclure cette
    chane.</p>

    <p>Lorsque la directive ProxyPass est utilise  l'intrieur d'une
    section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>, le premier argument est omis et le rpertoire
    local est obtenu  partir de la section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>. Il en sera de mme dans une
    section <code class="directive"><a href="../mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code> ; cependant, ProxyPass
    n'interprte pas les expressions rationnelles, et il sera ici
    ncessaire d'utiliser la directive
    <code class="directive">ProxyPassMatch</code>  la place.</p>

    <p>Cette directive ne peut pas tre place dans une section
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou
    <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>.</p>

    <p>Si vous avez besoin d'un configuration de mandataire inverse plus
    souple, reportez-vous  la documentaion de la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> et son drapeau
    <code>[P]</code>.</p>

    <p>Le mot-cl optionnel <var>interpolate</var>, en combinaison avec la directive
    <code class="directive">ProxyPassInterpolateEnv</code>, permet  ProxyPass
    d'interpoler les variables d'environnement  l'aide de la syntaxe
    <var>${VARNAME}</var>. Notez que de nombreuses variables
    d'environnement standard drives de CGI n'existeront pas lorsque
    l'interpolation se produit ; vous devrez alors encore avoir avoir
    recours  <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour des rgles
    complexes. Notez aussi que l'interpolation n'est pas supporte dans
    la partie protocole d'une URL. La dtermination dynamique du
    protocole peut tre effectue  l'aide de
    <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> comme dans l'exemple suivant :</p>

    <pre class="prettyprint lang-config">RewriteEngine On

RewriteCond %{HTTPS} =off
RewriteRule . - [E=protocol:http]
RewriteCond %{HTTPS} =on
RewriteRule . - [E=protocol:https]

RewriteRule ^/mirror/foo/(.*) %{ENV:protocol}://backend.example.com/$1 [P]
ProxyPassReverse  /mirror/foo/ http://backend.example.com/
ProxyPassReverse  /mirror/foo/ https://backend.example.com/</pre>



</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPassInherit" id="ProxyPassInherit">ProxyPassInherit</a> <a name="proxypassinherit" id="proxypassinherit">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Hritage des directives ProxyPass dfinies au niveau du
serveur principal</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPassInherit On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyPassInherit On</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible  partir de la version 2.4.5 du serveur
HTTP Apache.</td></tr>
</table>
        <p>Cette directive permet  un serveur virtuel d'hriter des
	directives <code class="directive"><a href="#proxypass">ProxyPass</a></code> dfinies
	au niveau du serveur principal. Si vous utilisez la fonctionnalit de
	modifications dynamiques du Balancer Manager, cette directive peut
	causer des problmes et des comportements inattendus et doit donc
	tre dsactive.</p>
        <p>Les valeurs dfinies au niveau du serveur principal
	constituent les valeurs par dfaut pour tous les serveurs virtuels.</p>
        <p>La dsactivation de ProxyPassInherit dsactive aussi la
	directive <code class="directive"><a href="#balancerinherit">BalancerInherit</a></code>.</p>
    
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPassInterpolateEnv" id="ProxyPassInterpolateEnv">ProxyPassInterpolateEnv</a> <a name="proxypassinterpolateenv" id="proxypassinterpolateenv">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active l'interpolation des variables d'environnement dans
les configurations de mandataires inverses</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPassInterpolateEnv On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyPassInterpolateEnv Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2.9 d'Apache</td></tr>
</table>
    <p>Cette directive, ainsi que l'argument <var>interpolate</var> des
    directives <code class="directive">ProxyPass</code>,
    <code class="directive">ProxyPassReverse</code>,
    <code class="directive">ProxyPassReverseCookieDomain</code> et
    <code class="directive">ProxyPassReverseCookiePath</code>, permet de
    configurer dynamiquement un mandataire inverse  l'aide de
    variables d'environnement, ces dernires pouvant tre dfinies par un
    autre module comme <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Elle affecte les
    directives <code class="directive">ProxyPass</code>,
    <code class="directive">ProxyPassReverse</code>,
    <code class="directive">ProxyPassReverseCookieDomain</code>, et
    <code class="directive">ProxyPassReverseCookiePath</code>, en leur indiquant
    de remplacer la chane <code>${nom_var}</code> dans les directives
    de configuration par la valeur de la variable d'environnement
    <code>nom_var</code> (si l'option <var>interpolate</var> est
    spcifie).</p>
    <p>Conservez cette directive  off (pour les performances du
    serveur), sauf si vous en avez rellement besoin.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPassMatch" id="ProxyPassMatch">ProxyPassMatch</a> <a name="proxypassmatch" id="proxypassmatch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Fait correspondre des serveurs distants dans l'espace d'URL
du serveur local en utilisant des expressions rationnelles</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPassMatch [<var>regex</var>] !|<var>url</var>
[<var>cl=valeur</var>
	<var>[cl=valeur</var> ...]]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive est identique  la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code>, mais fait usage des
    expressions rationnelles, au lieu d'une simple comparaison de
    prfixes. L'expression rationnelle spcifie est compare 
    l'<var>url</var>, et si elle correspond, le serveur va substituer
    toute correspondance entre parenthses dans la chane donne et
    l'utiliser comme nouvelle <var>url</var>.</p>

    <div class="note"><strong>Note : </strong>Cette directive ne peut pas tre
    utilise dans un contexte de niveau rpertoire.</div>

    <p>Supposons que le serveur local a pour adresse
    <code>http://example.com/</code> ; alors</p>

    <pre class="prettyprint lang-config">ProxyPassMatch ^(/.*\.gif)$ http://backend.example.com$1</pre>


    <p>va provoquer la conversion interne de la requte locale
    <code>http://example.com/foo/bar.gif</code> en une requte mandate
    pour <code>http://backend.example.com/foo/bar.gif</code>.</p>

    <div class="note"><h3>Note</h3>
      <p>L'argument URL doit pouvoir tre interprt en tant qu'URL
      <em>avant</em> les substitutions d'expressions rationnelles (et
      doit aussi l'tre aprs). Ceci limite les correspondances que vous
      pouvez utiliser. Par exemple, si l'on avait utilis</p>
      <pre class="prettyprint lang-config">ProxyPassMatch ^(/.*\.gif)$ http://backend.example.com:8000$1</pre>

      <p>dans l'exemple prcdent, nous aurions provoqu une erreur de
      syntaxe au dmarrage du serveur. C'est une bogue (PR 46665 dans
      ASF bugzilla), et il est possible de la contourner en reformulant
      la correspondance :</p>
      <pre class="prettyprint lang-config">ProxyPassMatch ^/(.*\.gif)$ http://backend.example.com:8000/$1</pre>

    </div>

    <p>Le drapeau <code>!</code> vous permet de ne pas mandater un
    sous-rpertoire donn.</p>

    <p>Dans une section <code class="directive"><a href="../mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>, le premier argument est
    omis et l'expression rationnelle est obtenue  partir de la directive
    <code class="directive"><a href="../mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>.</p>

    <p>Si vous avez besoin d'une configuration du mandataire inverse
    plus flexible, voyez la directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> avec le drapeau
    <code>[P]</code>.</p>

    <div class="warning">
      <h3>Avertissement  propos de la scurit</h3>
      <p>Lors de la construction de l'URL cible de la rgle, il convient
      de prendre en compte l'impact en matire de scurit qu'aura le
      fait de permettre au client d'influencer le jeu d'URLs pour
      lesquelles votre serveur agira en tant que mandataire.
      Assurez-vous que la partie protocole://nom-serveur de l'URL soit
      fixe, ou ne permette pas au client de l'influencer induement.</p>
    </div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPassReverse" id="ProxyPassReverse">ProxyPassReverse</a> <a name="proxypassreverse" id="proxypassreverse">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajuste l'URL dans les en-ttes de la rponse HTTP envoye
par un serveur mandat en inverse</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPassReverse [<var>chemin</var>] <var>url</var>
[<var>interpolate</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive permet de faire en sorte qu'Apache httpd ajuste l'URL
    dans les en-ttes <code>Location</code>,
    <code>Content-Location</code> et <code>URI</code> des rponses de
    redirection HTTP. Ceci est essentiel lorsqu'Apache httpd est utilis en
    tant que mandataire inverse (ou passerelle), afin d'viter de
    court-circuiter le mandataire inverse suite aux redirections HTTP
    sur le serveur d'arrire-plan qui restent derrire le mandataire
    inverse.</p>

    <p>Seuls les en-ttes de rponse HTTP spcialement mentionns
    ci-dessus seront rcrits. Apache httpd ne rcrira ni les autres en-ttes
    de rponse, ni par dfaut les rfrences d'URLs dans les pages HTML. Cela
    signifie que dans le cas o un contenu mandat contient des
    rfrences  des URLs absolues, elles court-circuiteront le
    mandataire. Pour rcrire un contenu HTML afin qu'il corresponde au
    mandataire, vous devez charger et activer le module
    <code class="module"><a href="../mod/mod_proxy_html.html">mod_proxy_html</a></code>.
    </p>

    <p><var>chemin</var> est le nom d'un chemin virtuel local.
    <var>url</var> est une URL partielle pour le serveur distant - ils
    sont utiliss de la mme faon qu'avec la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code>.</p>

    <p>Supposons par exemple que le serveur local a pour adresse
    <code>http://example.com/</code> ; alors</p>

    <pre class="prettyprint lang-config">ProxyPass         /mirror/foo/ http://backend.example.com/
ProxyPassReverse  /mirror/foo/ http://backend.example.com/
ProxyPassReverseCookieDomain  backend.example.com  public.example.com
ProxyPassReverseCookiePath  /  /mirror/foo/</pre>


    <p>ne va pas seulement provoquer la conversion interne d'une requte
    locale pour <code>http://example.com/miroir/foo/bar</code> en une
    requte mandate pour <code>http://backend.example.com/bar</code>
    (la fonctionnalit fournie par <code>ProxyPass</code>). Il va
    aussi s'occuper des redirections que le serveur
    <code>backend.example.com</code> envoie : lorsque
    <code>http://backend.example.com/bar</code> est redirig par
    celui-ci vers <code>http://backend.example.com/quux</code>, Apache
    httpd corrige ceci en <code>http://example.com/miroir/foo/quux</code>
    avant de faire suivre la redirection HTTP au client. Notez que le
    nom d'hte utilis pour construire l'URL est choisi en respectant la
    dfinition de la directive <code class="directive"><a href="../mod/core.html#usecanonicalname">UseCanonicalName</a></code>.</p>

    <p>Notez que la directive <code class="directive">ProxyPassReverse</code>
    peut aussi tre utilise en conjonction avec la fonctionnalit
    pass-through (<code>RewriteRule ...  [P]</code>) du module
    <code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>, car elle ne dpend pas d'une directive
    <code class="directive"><a href="#proxypass">ProxyPass</a></code>
    correspondante.</p>

    <p>Le mot-cl optionnel <var>interpolate</var>, en
    combinaison avec la directive
    <code class="directive">ProxyPassInterpolateEnv</code>, permet
    l'interpolation des variables d'environnement spcifies en
    utilisant le format <var>${VARNAME}</var> Notez que l'interpolation
    n'est pas supporte dans la partie protocole d'une URL.
    </p>

    <p>Lorsque cette directive est utilise dans une section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>, le premier
    argument est omis et le rpertoire local est obtenu  partir de
    l'argument de la directive <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code>. Il en est de mme  l'intrieur
    d'une section <code class="directive"><a href="../mod/core.html#locationmatch">&lt;LocationMatch&gt;</a></code>, mais le rsultat ne sera
    probablement pas celui attendu car ProxyPassReverse va interprter
    l'expression rationnelle littralement comme un chemin ; si besoin
    est dans ce cas, dfinissez la directive ProxyPassReverse en dehors
    de la section, ou dans une section <code class="directive"><a href="../mod/core.html#location">&lt;Location&gt;</a></code> spare.</p>

    <p>Cette directive ne peut pas tre place dans une section
    <code class="directive"><a href="../mod/core.html#directory">&lt;Directory&gt;</a></code> ou
    <code class="directive"><a href="../mod/core.html#files">&lt;Files&gt;</a></code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPassReverseCookieDomain" id="ProxyPassReverseCookieDomain">ProxyPassReverseCookieDomain</a> <a name="proxypassreversecookiedomain" id="proxypassreversecookiedomain">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajuste la chane correspondant au domaine dans les en-ttes
Set-Cookie en provenance d'un serveur mandat</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPassReverseCookieDomain <var>domaine-interne</var>
<var>domaine-public</var> [<var>interpolate</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
<p>L'utilisation de cette directive est similaire  celle de la
directive <code class="directive"><a href="#proxypassreverse">ProxyPassReverse</a></code>,
mais au lieu de rcrire des en-ttes qui contiennent des URLs, elle
rcrit la chane correspondant au domaine dans les en-ttes
<code>Set-Cookie</code>.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPassReverseCookiePath" id="ProxyPassReverseCookiePath">ProxyPassReverseCookiePath</a> <a name="proxypassreversecookiepath" id="proxypassreversecookiepath">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Ajuste la chane correspondant au chemin dans les en-ttes
Set-Cookie en provenance d'un serveur mandat</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPassReverseCookiePath <var>chemin-interne</var>
<var>chemin-public</var> [<var>interpolate</var>]</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
<p>
Cette directive s'avre utile en conjonction avec la directive
<code class="directive"><a href="#proxypassreverse">ProxyPassReverse</a></code> dans les
situations o les chemins d'URL d'arrire-plan correspondent  des
chemins publics sur le mandataire inverse. Cette directive permet de
rcrire la chane <code>path</code> dans les en-ttes
<code>Set-Cookie</code>. Si le dbut du chemin du cookie correspond 
<var>chemin-interne</var>, le chemin du cookie sera remplac par
<var>chemin-public</var>.
</p><p>
Dans l'exemple fourni avec la directive <code class="directive"><a href="#proxypassreverse">ProxyPassReverse</a></code>, la directive :
</p>
    <pre class="prettyprint lang-config">ProxyPassReverseCookiePath  /  /mirror/foo/</pre>

<p>
va rcrire un cookie possdant un chemin d'arrire-plan <code>/</code>
(ou <code>/example</code> ou en fait tout chemin)
en <code>/mirror/foo/</code>..
</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyPreserveHost" id="ProxyPreserveHost">ProxyPreserveHost</a> <a name="proxypreservehost" id="proxypreservehost">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Utilise l'en-tte de requte entrante Host pour la requte
du mandataire</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyPreserveHost On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyPreserveHost Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel, rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Utilisable
dans un contexte de rpertoire depuis la version 2.3.3.</td></tr>
</table>
    <p>Lorsqu'elle est active, cette directive va transmettre l'en-tte
    Host: de la requte entrante vers le serveur mandat, au lieu du nom
    d'hte spcifi par la directive <code class="directive">ProxyPass</code>.</p>

    <p>Cette directive est habituellement dfinie  <code>Off</code>.
    Elle est principalement utile dans les configurations particulires
    comme l'hbergement virtuel mandat en masse  base de nom, o
    l'en-tte Host d'origine doit tre valu par le serveur
    d'arrire-plan.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyReceiveBufferSize" id="ProxyReceiveBufferSize">ProxyReceiveBufferSize</a> <a name="proxyreceivebuffersize" id="proxyreceivebuffersize">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Taille du tampon rseau pour les connexions mandates HTTP
et FTP</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyReceiveBufferSize <var>octets</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyReceiveBufferSize 0</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>La directive <code class="directive">ProxyReceiveBufferSize</code> permet
    de spcifier une taille de tampon rseau explicite (TCP/IP) pour les
    connexions mandates HTTP et FTP, afin d'amliorer le dbit de
    donnes. Elle doit tre suprieure  <code>512</code> ou dfinie 
    <code>0</code> pour indiquer que la taille de tampon par dfaut du
    systme doit tre utilise.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ProxyReceiveBufferSize 2048</pre>
</div>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyRemote" id="ProxyRemote">ProxyRemote</a> <a name="proxyremote" id="proxyremote">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Mandataire distant  utiliser pour traiter certaines
requtes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyRemote <var>comparaison</var> <var>serveur-distant</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive permet de dfinir des mandataires distants pour
    ce mandataire. <var>comparaison</var> est soit le nom d'un protocole
    que supporte le serveur distant, soit une URL partielle pour
    laquelle le serveur distant devra tre utilis, soit <code>*</code>
    pour indiquer que le serveur distant doit tre utilis pour toutes
    les requtes. <var>serveur-distant</var> est une URL partielle
    correspondant au serveur distant. Syntaxe : </p>

    <div class="example"><p><code>
      <dfn>serveur-distant</dfn> =
          <var>protocole</var>://<var>nom-serveur</var>[:<var>port</var>]
    </code></p></div>

    <p><var>protocole</var> est effectivement le protocole  utiliser
    pour communiquer avec le serveur distant ; ce module ne supporte que
    <code>http</code> et <code>https</code>. Lorsqu'on utilise
    <code>https</code>, les requtes sont rediriges par le mandataire
    distant en utilisant la mthode HTTP CONNECT.</p>

    <div class="example"><h3>Exemple</h3><pre class="prettyprint lang-config">ProxyRemote http://goodguys.example.com/ http://mirrorguys.example.com:8000
ProxyRemote * http://cleverproxy.localdomain
ProxyRemote ftp http://ftpproxy.mydomain:8080</pre>
</div>

    <p>Dans la dernire ligne de l'exemple, le mandataire va faire
    suivre les requtes FTP, encapsules dans une autre requte mandate
    HTTP, vers un autre mandataire capable de les traiter.</p>

    <p>Cette directive supporte aussi les configurations de mandataire
    inverse - un serveur web d'arrire-plan peut tre intgr dans
    l'espace d'URL d'un serveur virtuel, mme si ce serveur est cach
    par un autre mandataire direct.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyRemoteMatch" id="ProxyRemoteMatch">ProxyRemoteMatch</a> <a name="proxyremotematch" id="proxyremotematch">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Le mandataire distant  utiliser pour traiter les requtes
correspondant  une expression rationnelle</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyRemoteMatch <var>regex</var> <var>serveur-distant</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>La directive <code class="directive">ProxyRemoteMatch</code> est
    identique  la directive <code class="directive"><a href="#proxyremote">ProxyRemote</a></code>,  l'exception du
    premier argument qui est une <a class="glossarylink" href="../glossary.html#regex" title="voir glossaire">expression
    rationnelle</a>  mettre en correspondance avec l'URL de la
    requte.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyRequests" id="ProxyRequests">ProxyRequests</a> <a name="proxyrequests" id="proxyrequests">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Active la fonctionnalit (standard) de mandataire
direct</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyRequests On|Off</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyRequests Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive permet d'activer/dsactiver la fonctionnalit de
    serveur mandataire direct d'Apache httpd. Dfinir ProxyRequests 
    <code>Off</code> n'interdit pas l'utilisation de la directive
    <code class="directive"><a href="#proxypass">ProxyPass</a></code>.</p>

    <p>Pour une configuration typique de mandataire inverse ou
    passerelle, cette directive doit tre dfinie 
    <code>Off</code>.</p>

    <p>Afin d'activer la fonctionnalit de mandataire pour des sites
    HTTP et/ou FTP, les modules <code class="module"><a href="../mod/mod_proxy_http.html">mod_proxy_http</a></code> et/ou
    <code class="module"><a href="../mod/mod_proxy_ftp.html">mod_proxy_ftp</a></code> doivent galement tre chargs dans le
    serveur.</p>

    <p>Pour activer la fonctionnalit de mandataire sur les sites chiffrs en HTTPS, le module
    <code class="module"><a href="../mod/mod_proxy_connect.html">mod_proxy_connect</a></code> doit galement tre charg dans le serveur.</p>

    <div class="warning"><h3>Avertissement</h3>
      <p>N'activez pas la fonctionnalit de mandataire avec la directive
      <code class="directive"><a href="#proxyrequests">ProxyRequests</a></code> avant
      d'avoir <a href="#access">scuris votre serveur</a>. Les serveurs
      mandataires ouverts sont dangereux non seulement pour votre
      rseau, mais aussi pour l'Internet au sens large.</p>
    </div>

<h3>Voir aussi</h3>
<ul>
<li><a href="#forwardreverse">Mandataires/Passerelles directs et
inverses</a></li>
</ul>
</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxySet" id="ProxySet">ProxySet</a> <a name="proxyset" id="proxyset">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit diffrents paramtres relatifs  la rpartition de
charge des mandataires et aux membres des groupes de rpartition de
charge</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxySet <var>url</var> <var>cl=valeur [cl=valeur ...]</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>rpertoire</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>ProxySet n'est disponible que depuis la version 2.2
du serveur HTTP Apache.</td></tr>
</table>
    <p>Cette directive propose une mthode alternative pour dfinir tout
    paramtre relatif aux rpartiteurs de charge et serveurs cibles de
    mandataires normalement dfinis via la directive <code class="directive"><a href="#proxypass">ProxyPass</a></code>. Si elle se trouve dans un
    conteneur <code>&lt;Proxy <var>url de rpartiteur|url de
    serveur cible</var>&gt;</code>, l'argument <var>url</var> n'est pas
    ncessaire. Comme effet de bord, le rpartiteur ou serveur cible respectif
    est cr. Ceci peut s'avrer utile pour la mise en oeuvre d'un
    mandataire inverse via une directive <code class="directive"><a href="../mod/mod_rewrite.html#rewriterule">RewriteRule</a></code> au lieu de <code class="directive"><a href="#proxypass">ProxyPass</a></code>.</p>

    <div class="example"><pre class="prettyprint lang-config">&lt;Proxy balancer://hotcluster&gt;
    BalancerMember http://www2.example.com:8080 loadfactor=1
    BalancerMember http://www3.example.com:8080 loadfactor=2
    ProxySet lbmethod=bytraffic
&lt;/Proxy&gt;</pre>
</div>

    <pre class="prettyprint lang-config">&lt;Proxy http://backend&gt;
    ProxySet keepalive=On
&lt;/Proxy&gt;</pre>


    <pre class="prettyprint lang-config">ProxySet balancer://foo lbmethod=bytraffic timeout=15</pre>


    <pre class="prettyprint lang-config">ProxySet ajp://backend:7001 timeout=15</pre>


   <div class="warning"><h3>Avertissement</h3>
      <p>Gardez  l'esprit qu'une mme cl de paramtre peut avoir
      diffrentes significations selon qu'elle s'applique  un
      rpartiteur ou  un serveur cible, et ceci est illustr par les deux
      exemples prcdents o il est question d'un timeout.</p>
   </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxySourceAddress" id="ProxySourceAddress">ProxySourceAddress</a> <a name="proxysourceaddress" id="proxysourceaddress">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dfinit l'adresse IP locale pour les connexions mandates
sortantes</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxySourceAddress <var>adresse</var></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.3.9</td></tr>
</table>
    <p>Cette directive permet de dfinir une adresse IP locale
    spcifique  laquelle faire rfrence lors d'une connexion  un
    serveur d'arrire-plan.</p>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyStatus" id="ProxyStatus">ProxyStatus</a> <a name="proxystatus" id="proxystatus">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Affiche l'tat du rpartiteur de charge du mandataire dans
mod_status</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyStatus Off|On|Full</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyStatus Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
<tr><th><a href="directive-dict.html#Compatibility">Compatibilit:</a></th><td>Disponible depuis la version 2.2 d'Apache</td></tr>
</table>
    <p>Cette directive permet de spcifier si les donnes d'tat du
    rpartiteur de charge du mandataire doivent tre affiches via la
    page d'tat du serveur du module <code class="module"><a href="../mod/mod_status.html">mod_status</a></code>.</p>
    <div class="note"><h3>Note</h3>
      <p>L'argument <strong>Full</strong> produit le mme effet que
      l'argument <strong>On</strong>.</p>
    </div>


</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyTimeout" id="ProxyTimeout">ProxyTimeout</a> <a name="proxytimeout" id="proxytimeout">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Dlai d'attente rseau pour les requtes
mandates</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyTimeout <var>secondes</var></code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>Valeur de la directive <code class="directive"><a href="../mod/core.html#timeout">Timeout</a></code></code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive permet  l'utilisateur de spcifier un dlai pour
    les requtes mandates. Ceci s'avre utile dans le cas d'un serveur
    d'applications lent et bogu qui a tendance  se bloquer, et si vous
    prfrez simplement renvoyer une erreur timeout et abandonner la
    connexion en douceur plutt que d'attendre jusqu' ce que le serveur
    veuille bien rpondre.</p>

</div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="directive-section"><h2><a name="ProxyVia" id="ProxyVia">ProxyVia</a> <a name="proxyvia" id="proxyvia">Directive</a></h2>
<table class="directive">
<tr><th><a href="directive-dict.html#Description">Description:</a></th><td>Information fournie dans l'en-tte de rponse HTTP
<code>Via</code> pour les requtes mandates</td></tr>
<tr><th><a href="directive-dict.html#Syntax">Syntaxe:</a></th><td><code>ProxyVia On|Off|Full|Block</code></td></tr>
<tr><th><a href="directive-dict.html#Default">Dfaut:</a></th><td><code>ProxyVia Off</code></td></tr>
<tr><th><a href="directive-dict.html#Context">Contexte:</a></th><td>configuration du serveur, serveur virtuel</td></tr>
<tr><th><a href="directive-dict.html#Status">Statut:</a></th><td>Extension</td></tr>
<tr><th><a href="directive-dict.html#Module">Module:</a></th><td>mod_proxy</td></tr>
</table>
    <p>Cette directive permet de contrler l'utilisation de l'en-tte
    HTTP <code>Via:</code> par le mandataire. Le but recherch est de
    contrler le flux des requtes mandates tout au long d'une chane
    de serveurs mandataires. Voir <a href="http://www.ietf.org/rfc/rfc2616.txt">RFC 2616</a> (HTTP/1.1),
    section 14.45 pour une description des lignes d'en-tte
    <code>Via:</code>.</p>

    <ul>
    <li>Si elle est dfinie  <code>Off</code>, valeur par dfaut, cette
    directive n'effectue aucun traitement particulier. Si une requte ou
    une rponse contient un en-tte <code>Via:</code>, il est transmis
    sans modification.</li>

    <li>Si elle est dfinie  <code>On</code>, chaque requte ou rponse
    se verra ajouter une ligne d'en-tte <code>Via:</code> pour le
    serveur courant.</li>

    <li>Si elle est dfinie  <code>Full</code>, chaque ligne d'en-tte
    <code>Via:</code> se verra ajouter la version du serveur Apache
    httpd sous la forme d'un champ de commentaire <code>Via:</code>.</li>

    <li>Si elle est dfinie  <code>Block</code>, chaque requte
    mandate verra ses lignes d'en-tte <code>Via:</code> supprimes.
    Aucun nouvel en-tte <code>Via:</code> ne sera gnr.</li>
    </ul>

</div>
</div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/mod/mod_proxy.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/mod/mod_proxy.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/mod/mod_proxy.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/mod/mod_proxy.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2014 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>