/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.migrationtools.tests.e2e.impl;

import static org.assertj.core.api.Assertions.assertThat;

import com.google.auto.service.AutoService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ignite.examples.model.Person;
import org.apache.ignite.migrationtools.tests.e2e.framework.core.ExampleBasedCacheTest;

/** PersonCacheTest. */
@AutoService(ExampleBasedCacheTest.class)
public class PersonCacheTest extends VeryBasicAbstractCacheTest<Integer, Person> {

    public PersonCacheTest() {
        super(Integer.class, Person.class);
    }

    @Override
    public String getTableName() {
        return "MyPersonPojoCache";
    }

    @Override
    public Map.Entry<Integer, Person> supplyExample(int seed) {
        Person p = new Person((long) seed, 1_000_000L + seed, "Some First Name", "Some Last Name", 200.25 * seed, "Unremarkable");
        return Map.entry(seed, p);
    }

    @Override
    protected void assertResultSet(ResultSet rs, Person expectedObj) throws SQLException {
        // TODO: This could be autogenerated as well.
        assertThat(rs.getLong("ID")).isEqualTo(expectedObj.id);
        assertThat(rs.getLong("orgId")).isEqualTo(expectedObj.orgId);
        assertThat(rs.getString("firstName")).isEqualTo(expectedObj.firstName);
        assertThat(rs.getString("lastName")).isEqualTo(expectedObj.lastName);
        assertThat(rs.getString("resume")).isEqualTo(expectedObj.resume);
        assertThat(rs.getDouble("salary")).isEqualTo(expectedObj.salary);
    }
}
