/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.RolesFinder;
import io.micronaut.security.token.config.TokenConfiguration;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@Singleton
public class DefaultRolesFinder
implements RolesFinder {
    private final TokenConfiguration tokenConfiguration;

    public DefaultRolesFinder(TokenConfiguration tokenConfiguration) {
        this.tokenConfiguration = tokenConfiguration;
    }

    @NonNull
    private List<String> rolesAtObject(@Nullable Object rolesObject) {
        if (rolesObject == null) {
            return Collections.emptyList();
        }
        if (rolesObject instanceof CharSequence && this.tokenConfiguration.getRolesSeparator() != null) {
            return Arrays.asList(rolesObject.toString().split(this.tokenConfiguration.getRolesSeparator()));
        }
        if (rolesObject instanceof Iterable) {
            ArrayList<String> roles = new ArrayList<String>();
            for (Object o : (Iterable)rolesObject) {
                roles.add(o.toString());
            }
            return roles;
        }
        return Collections.singletonList(rolesObject.toString());
    }

    @Override
    @NonNull
    public List<String> resolveRoles(@Nullable Map<String, Object> attributes) {
        return this.rolesAtObject(attributes != null ? attributes.get(this.tokenConfiguration.getRolesName()) : null);
    }
}

