/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cluster.metric;

import jakarta.inject.Singleton;
import java.util.List;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.rest.client.api.ClusterMetricApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.model.NodeMetricSources;

@Singleton
public class ClusterMetricSourceListCall
implements Call<UrlCallInput, List<NodeMetricSources>> {
    private final ApiClientFactory clientFactory;

    public ClusterMetricSourceListCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<List<NodeMetricSources>> execute(UrlCallInput input) {
        try {
            return DefaultCallOutput.success(this.listNodeMetricSources(input));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getUrl()));
        }
    }

    private List<NodeMetricSources> listNodeMetricSources(UrlCallInput input) throws ApiException {
        return new ClusterMetricApi(this.clientFactory.getClient(input.getUrl())).listClusterMetricSources();
    }
}

