/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.flow;

import java.util.function.Supplier;
import org.apache.ignite.internal.cli.core.flow.DefaultFlowable;
import org.apache.ignite.internal.cli.core.flow.FlowInterruptException;

public interface Flowable<T> {
    default public boolean hasResult() {
        return this.value() != null;
    }

    public Class<T> type();

    public T value();

    default public boolean hasError() {
        return this.errorCause() != null;
    }

    public Throwable errorCause();

    public static <O> O interrupt() {
        throw new FlowInterruptException();
    }

    public static <T> Flowable<T> process(Supplier<T> supplier) {
        try {
            return Flowable.success(supplier.get());
        }
        catch (FlowInterruptException e) {
            throw e;
        }
        catch (Exception e) {
            return Flowable.failure(e);
        }
    }

    public static <T> Flowable<T> success(T body) {
        return DefaultFlowable.builder().body(body).build();
    }

    public static <T> Flowable<T> failure(Throwable cause) {
        return DefaultFlowable.builder().cause(cause).build();
    }

    public static <T> Flowable<T> empty() {
        return DefaultFlowable.builder().build();
    }
}

