/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.table;

import java.util.List;
import java.util.Objects;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.marshalling.Marshaller;
import org.apache.ignite.table.DataStreamerReceiver;
import org.apache.ignite.table.ReceiverExecutionOptions;
import org.jetbrains.annotations.Nullable;

public class DataStreamerReceiverDescriptor<T, A, R> {
    private final String receiverClassName;
    private final List<DeploymentUnit> units;
    private final ReceiverExecutionOptions options;
    @Nullable
    private final Marshaller<T, byte[]> payloadMarshaller;
    @Nullable
    private final Marshaller<A, byte[]> argumentMarshaller;
    @Nullable
    private final Marshaller<R, byte[]> resultMarshaller;

    private DataStreamerReceiverDescriptor(String receiverClassName, List<DeploymentUnit> units, ReceiverExecutionOptions options, @Nullable Marshaller<T, byte[]> payloadMarshaller, @Nullable Marshaller<A, byte[]> argumentMarshaller, @Nullable Marshaller<R, byte[]> resultMarshaller) {
        Objects.requireNonNull(receiverClassName);
        Objects.requireNonNull(units);
        this.receiverClassName = receiverClassName;
        this.units = units;
        this.options = options;
        this.payloadMarshaller = payloadMarshaller;
        this.argumentMarshaller = argumentMarshaller;
        this.resultMarshaller = resultMarshaller;
    }

    public String receiverClassName() {
        return this.receiverClassName;
    }

    public List<DeploymentUnit> units() {
        return this.units;
    }

    public ReceiverExecutionOptions options() {
        return this.options;
    }

    @Nullable
    public Marshaller<T, byte[]> payloadMarshaller() {
        return this.payloadMarshaller;
    }

    @Nullable
    public Marshaller<A, byte[]> argumentMarshaller() {
        return this.argumentMarshaller;
    }

    @Nullable
    public Marshaller<R, byte[]> resultMarshaller() {
        return this.resultMarshaller;
    }

    public static <T, A, R> Builder<T, A, R> builder(String receiverClassName) {
        Objects.requireNonNull(receiverClassName);
        return new Builder(receiverClassName);
    }

    public static <T, A, R> Builder<T, A, R> builder(Class<? extends DataStreamerReceiver<T, A, R>> receiverClass) {
        Objects.requireNonNull(receiverClass);
        return new Builder(receiverClass.getName());
    }

    public static <T, A, R> Builder<T, A, R> builder(DataStreamerReceiver<T, A, R> receiver) {
        Objects.requireNonNull(receiver);
        return new Builder(receiver.getClass().getName()).payloadMarshaller(receiver.payloadMarshaller()).argumentMarshaller(receiver.argumentMarshaller()).resultMarshaller(receiver.resultMarshaller());
    }

    public static class Builder<T, A, R> {
        private final String receiverClassName;
        private List<DeploymentUnit> units;
        @Nullable
        private Marshaller<T, byte[]> payloadMarshaller;
        @Nullable
        private Marshaller<A, byte[]> argumentMarshaller;
        @Nullable
        private Marshaller<R, byte[]> resultMarshaller;
        private ReceiverExecutionOptions options = ReceiverExecutionOptions.DEFAULT;

        private Builder(String receiverClassName) {
            Objects.requireNonNull(receiverClassName);
            this.receiverClassName = receiverClassName;
        }

        public Builder<T, A, R> units(List<DeploymentUnit> units) {
            this.units = units;
            return this;
        }

        public Builder<T, A, R> units(DeploymentUnit ... units) {
            this.units = List.of(units);
            return this;
        }

        public Builder<T, A, R> options(ReceiverExecutionOptions options) {
            this.options = options;
            return this;
        }

        public Builder<T, A, R> payloadMarshaller(@Nullable Marshaller<T, byte[]> payloadMarshaller) {
            this.payloadMarshaller = payloadMarshaller;
            return this;
        }

        public Builder<T, A, R> argumentMarshaller(@Nullable Marshaller<A, byte[]> argumentMarshaller) {
            this.argumentMarshaller = argumentMarshaller;
            return this;
        }

        public Builder<T, A, R> resultMarshaller(@Nullable Marshaller<R, byte[]> resultMarshaller) {
            this.resultMarshaller = resultMarshaller;
            return this;
        }

        public DataStreamerReceiverDescriptor<T, A, R> build() {
            return new DataStreamerReceiverDescriptor<T, A, R>(this.receiverClassName, this.units != null ? this.units : List.of(), this.options, this.payloadMarshaller, this.argumentMarshaller, this.resultMarshaller);
        }
    }
}

