/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.cache.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.bulkload.BulkLoadProcessor;
import org.jetbrains.annotations.NotNull;

public class BulkLoadContextCursor
implements FieldsQueryCursor<List<?>> {
    private final BulkLoadProcessor processor;
    private final BulkLoadAckClientParameters clientParams;

    public BulkLoadContextCursor(BulkLoadProcessor processor, BulkLoadAckClientParameters clientParams) {
        this.processor = processor;
        this.clientParams = clientParams;
    }

    public BulkLoadProcessor bulkLoadProcessor() {
        return this.processor;
    }

    public BulkLoadAckClientParameters clientParams() {
        return this.clientParams;
    }

    @Override
    public List<List<?>> getAll() {
        return Collections.singletonList(Arrays.asList(this.processor, this.clientParams));
    }

    @Override
    @NotNull
    public Iterator<List<?>> iterator() {
        return this.getAll().iterator();
    }

    @Override
    public void close() {
    }

    @Override
    public String getFieldName(int idx) {
        if (idx < 0 || idx > 1) {
            throw new IndexOutOfBoundsException();
        }
        return idx == 0 ? "processor" : "clientParams";
    }

    @Override
    public int getColumnsCount() {
        return 2;
    }
}

