/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.util.future.GridFutureAdapter;

public class UnregisteredBinaryTypeException
extends IgniteException {
    private static final long serialVersionUID = 0L;
    private static final String MESSAGE = "Attempted to update binary metadata inside a critical synchronization block (will be automatically retried). This exception must not be wrapped to any other exception class. If you encounter this exception outside of EntryProcessor, please report to Apache Ignite dev-list. Debug info [typeId=%d, binaryMetadata=%s, fut=%s]";
    private final int typeId;
    private final BinaryMetadata binaryMetadata;
    private final GridFutureAdapter<?> fut;

    private static String createMessage(int typeId, BinaryMetadata binaryMetadata, GridFutureAdapter<?> fut) {
        return String.format(MESSAGE, typeId, binaryMetadata, fut);
    }

    public UnregisteredBinaryTypeException(int typeId, BinaryMetadata binaryMetadata) {
        this(typeId, binaryMetadata, null);
    }

    public UnregisteredBinaryTypeException(int typeId, GridFutureAdapter<?> fut) {
        this(typeId, null, fut);
    }

    private UnregisteredBinaryTypeException(int typeId, BinaryMetadata binaryMetadata, GridFutureAdapter<?> fut) {
        super(UnregisteredBinaryTypeException.createMessage(typeId, binaryMetadata, fut));
        this.typeId = typeId;
        this.binaryMetadata = binaryMetadata;
        this.fut = fut;
    }

    public int typeId() {
        return this.typeId;
    }

    public BinaryMetadata binaryMetadata() {
        return this.binaryMetadata;
    }

    public GridFutureAdapter<?> future() {
        return this.fut;
    }
}

