/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.cache.CacheContentionCommandArg;
import org.apache.ignite.internal.management.cache.ContentionInfo;
import org.apache.ignite.internal.management.cache.ContentionTask;
import org.apache.ignite.internal.management.cache.ContentionTaskResult;

public class CacheContentionCommand
implements ComputeCommand<CacheContentionCommandArg, ContentionTaskResult> {
    @Override
    public String description() {
        return "Show the keys that are point of contention for multiple transactions";
    }

    @Override
    public Class<CacheContentionCommandArg> argClass() {
        return CacheContentionCommandArg.class;
    }

    @Override
    public Class<ContentionTask> taskClass() {
        return ContentionTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, CacheContentionCommandArg arg) {
        return CommandUtils.nodeOrAll(arg.nodeId(), nodes);
    }

    @Override
    public void printResult(CacheContentionCommandArg arg, ContentionTaskResult res, Consumer<String> printer) {
        CommandUtils.printErrors(res.exceptions(), "Contention check failed on nodes:", printer);
        for (ContentionInfo info : res.getInfos()) {
            info.print();
        }
    }
}

