/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tracing;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.tracing.TracingConfigurationItem;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.tracing.TracingConfigurationCoordinates;
import org.apache.ignite.spi.tracing.TracingConfigurationParameters;

public class TracingConfigurationTaskResult
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    private static final Character RES_PRINTER_SEPARATOR = Character.valueOf(',');
    private List<TracingConfigurationItem> tracingConfigurations = new ArrayList<TracingConfigurationItem>();

    public void add(TracingConfigurationCoordinates coordinates, TracingConfigurationParameters parameters) {
        this.tracingConfigurations.add(new TracingConfigurationItem(coordinates.scope(), coordinates.label(), parameters.samplingRate(), parameters.includedScopes()));
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeCollection(out, this.tracingConfigurations);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.tracingConfigurations = (List)U.readCollection(in);
    }

    public void print(Consumer<String> printer) {
        printer.accept("Scope, Label, Sampling Rate, included scopes");
        Collections.sort(this.tracingConfigurations, Comparator.comparing(TracingConfigurationItem::scope));
        for (TracingConfigurationItem tracingConfiguration : this.tracingConfigurations) {
            printer.accept(tracingConfiguration.scope().name() + RES_PRINTER_SEPARATOR + (tracingConfiguration.label() == null ? "" : tracingConfiguration.label()) + RES_PRINTER_SEPARATOR + tracingConfiguration.samplingRate() + RES_PRINTER_SEPARATOR + Arrays.toString(tracingConfiguration.includedScopes().toArray()));
        }
    }

    public List<TracingConfigurationItem> tracingConfigurations() {
        return this.tracingConfigurations;
    }
}

