/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.CliConfirmArgument;
import org.apache.ignite.internal.management.api.EnumDescription;
import org.apache.ignite.internal.management.tx.TxCommand;
import org.apache.ignite.internal.management.tx.TxSortOrder;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;

@CliConfirmArgument
@ArgumentGroup(value={"servers", "clients", "nodes"}, onlyOneOf=true, optional=true)
public class TxCommandArg
extends TxCommand.AbstractTxCommandArg {
    private static final long serialVersionUID = 0L;
    @Argument(example="XID", optional=true)
    private String xid;
    @Argument(example="SECONDS", optional=true)
    private Long minDuration;
    @Argument(example="SIZE", optional=true)
    private Integer minSize;
    @Argument(example="PATTERN_REGEX", optional=true)
    private String label;
    @Argument
    private boolean servers;
    @Argument
    private boolean clients;
    @Argument(example="consistentId1[,consistentId2,....,consistentIdN]")
    private String[] nodes;
    @Argument(optional=true, example="NUMBER")
    private Integer limit;
    @Argument(optional=true, description="Output order")
    @EnumDescription(names={"DURATION", "SIZE", "START_TIME"}, descriptions={"Sort by duration", "Sort by size", "Sort by start time"})
    private TxSortOrder order;
    @Argument(optional=true)
    private boolean kill;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.xid);
        out.writeObject(this.minDuration);
        out.writeObject(this.minSize);
        U.writeString(out, this.label);
        out.writeBoolean(this.servers);
        out.writeBoolean(this.clients);
        U.writeArray(out, this.nodes);
        out.writeObject(this.limit);
        U.writeEnum(out, this.order);
        out.writeBoolean(this.kill);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.xid = U.readString(in);
        this.minDuration = (Long)in.readObject();
        this.minSize = (Integer)in.readObject();
        this.label = U.readString(in);
        this.servers = in.readBoolean();
        this.clients = in.readBoolean();
        this.nodes = U.readArray(in, String.class);
        this.limit = (Integer)in.readObject();
        this.order = U.readEnum(in, TxSortOrder.class);
        this.kill = in.readBoolean();
    }

    public String xid() {
        return this.xid;
    }

    public void xid(String xid) {
        this.xid = xid;
    }

    public Long minDuration() {
        return this.minDuration;
    }

    public void minDuration(Long minDuration) {
        A.ensure(minDuration == null || minDuration > 0L, "--min-duration");
        if (minDuration != null) {
            this.minDuration = minDuration * 1000L;
        }
    }

    public Integer minSize() {
        return this.minSize;
    }

    public void minSize(Integer minSize) {
        A.ensure(minSize == null || minSize > 0, "--min-size");
        this.minSize = minSize;
    }

    public String label() {
        return this.label;
    }

    public void label(String label) {
        if (label != null) {
            try {
                Pattern.compile(label);
            }
            catch (PatternSyntaxException ignored) {
                throw new IllegalArgumentException("Illegal regex syntax");
            }
        }
        this.label = label;
    }

    public boolean servers() {
        return this.servers;
    }

    public void servers(boolean servers) {
        this.servers = servers;
    }

    public boolean clients() {
        return this.clients;
    }

    public void clients(boolean clients) {
        this.clients = clients;
    }

    public String[] nodes() {
        return this.nodes;
    }

    public void nodes(String[] nodes) {
        this.nodes = nodes;
    }

    public Integer limit() {
        return this.limit;
    }

    public void limit(Integer limit) {
        A.ensure(limit == null || limit > 0, "--limit");
        this.limit = limit;
    }

    public TxSortOrder order() {
        return this.order;
    }

    public void order(TxSortOrder order) {
        this.order = order;
    }

    public boolean kill() {
        return this.kill;
    }

    public void kill(boolean kill) {
        this.kill = kill;
    }
}

