/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import javax.cache.configuration.Factory;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.apache.ignite.cache.store.CacheStore;
import org.apache.ignite.internal.processors.cache.GridCacheLoaderWriterStore;
import org.jetbrains.annotations.Nullable;

class GridCacheLoaderWriterStoreFactory<K, V>
implements Factory<CacheStore<K, V>> {
    private static final long serialVersionUID = 0L;
    private final Factory<CacheLoader<K, V>> ldrFactory;
    private final Factory<CacheWriter<K, V>> writerFactory;

    GridCacheLoaderWriterStoreFactory(@Nullable Factory<CacheLoader<K, V>> ldrFactory, @Nullable Factory<CacheWriter<K, V>> writerFactory) {
        this.ldrFactory = ldrFactory;
        this.writerFactory = writerFactory;
        assert (ldrFactory != null || writerFactory != null);
    }

    public CacheStore<K, V> create() {
        CacheLoader ldr = this.ldrFactory == null ? null : (CacheLoader)this.ldrFactory.create();
        CacheWriter writer = this.writerFactory == null ? null : (CacheWriter)this.writerFactory.create();
        return new GridCacheLoaderWriterStore(ldr, writer);
    }

    Factory<CacheLoader<K, V>> loaderFactory() {
        return this.ldrFactory;
    }

    Factory<CacheWriter<K, V>> writerFactory() {
        return this.writerFactory;
    }
}

