/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.diagnostic.pagelocktracker;

import java.util.concurrent.atomic.AtomicLong;

public class MemoryCalculator {
    private final AtomicLong heapUsed = new AtomicLong();
    private final AtomicLong offHeapUsed = new AtomicLong();

    MemoryCalculator() {
        this.onHeapAllocated(64L);
    }

    public void onHeapAllocated(long bytes) {
        assert (bytes >= 0L);
        this.heapUsed.getAndAdd(bytes);
    }

    public void onOffHeapAllocated(long bytes) {
        assert (bytes >= 0L);
        this.offHeapUsed.getAndAdd(bytes);
    }

    public void onHeapFree(long bytes) {
        this.heapUsed.getAndAdd(-bytes);
    }

    public void onOffHeapFree(long bytes) {
        this.offHeapUsed.getAndAdd(-bytes);
    }

    public long getOffHeapUsed() {
        return this.offHeapUsed.get();
    }

    public long getHeapUsed() {
        return this.heapUsed.get();
    }
}

