/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;

public class FileUploader {
    private static final int CHUNK_SIZE = 0x100000;
    private final Path path;
    private final IgniteLogger log;

    public FileUploader(Path path, IgniteLogger log) {
        this.path = path;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void upload(SocketChannel writeChan, GridFutureAdapter<Long> finishFut) {
        FileChannel readChan;
        block9: {
            block8: {
                readChan = null;
                try {
                    long written;
                    File file = new File(this.path.toUri().getPath());
                    if (!file.exists()) {
                        finishFut.onDone(new IgniteCheckedException(new FileNotFoundException(file.getAbsolutePath())));
                        U.close(writeChan, this.log);
                        break block8;
                    }
                    readChan = FileChannel.open(this.path, StandardOpenOption.READ);
                    long size = readChan.size();
                    for (written = 0L; written < size; written += readChan.transferTo(written, 0x100000L, writeChan)) {
                    }
                    writeChan.shutdownOutput();
                    writeChan.shutdownInput();
                    finishFut.onDone(written);
                    U.close(writeChan, this.log);
                    break block9;
                }
                catch (IOException ex) {
                    finishFut.onDone(ex);
                    return;
                }
            }
            U.close(readChan, this.log);
            return;
        }
        U.close(readChan, this.log);
        return;
        finally {
            U.close(writeChan, this.log);
            U.close(readChan, this.log);
        }
    }
}

