/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.file;

import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import org.apache.ignite.internal.processors.cache.persistence.file.AbstractFileIO;
import org.apache.ignite.internal.processors.compress.FileSystemUtils;
import org.apache.ignite.internal.util.typedef.internal.U;

public class RandomAccessFileIO
extends AbstractFileIO {
    private final FileChannel ch;
    private final int fd;
    private final int fsBlockSize;

    public RandomAccessFileIO(File file, OpenOption ... modes) throws IOException {
        this.ch = FileChannel.open(file.toPath(), modes);
        this.fd = RandomAccessFileIO.getNativeFileDescriptor(this.ch);
        this.fsBlockSize = FileSystemUtils.getFileSystemBlockSize(this.fd);
    }

    private static int getNativeFileDescriptor(FileChannel ch) {
        FileDescriptor fd = (FileDescriptor)U.field(ch, "fd");
        return (Integer)U.field(fd, "fd");
    }

    @Override
    public int getFileSystemBlockSize() {
        return this.fsBlockSize;
    }

    @Override
    public long getSparseSize() {
        return FileSystemUtils.getSparseFileSize(this.fd);
    }

    @Override
    public int punchHole(long position, int len) {
        return (int)FileSystemUtils.punchHole(this.fd, position, len, this.fsBlockSize);
    }

    @Override
    public long position() throws IOException {
        return this.ch.position();
    }

    @Override
    public void position(long newPosition) throws IOException {
        this.ch.position(newPosition);
    }

    @Override
    public int read(ByteBuffer destBuf) throws IOException {
        return this.ch.read(destBuf);
    }

    @Override
    public int read(ByteBuffer destBuf, long position) throws IOException {
        return this.ch.read(destBuf, position);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.ch.read(ByteBuffer.wrap(buf, off, len));
    }

    @Override
    public int write(ByteBuffer srcBuf) throws IOException {
        return this.ch.write(srcBuf);
    }

    @Override
    public int write(ByteBuffer srcBuf, long position) throws IOException {
        return this.ch.write(srcBuf, position);
    }

    @Override
    public int write(byte[] buf, int off, int len) throws IOException {
        return this.ch.write(ByteBuffer.wrap(buf, off, len));
    }

    @Override
    public void force(boolean withMetadata) throws IOException {
        this.ch.force(withMetadata);
    }

    @Override
    public long size() throws IOException {
        return this.ch.size();
    }

    @Override
    public void clear() throws IOException {
        this.ch.truncate(0L);
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }

    @Override
    public MappedByteBuffer map(int sizeBytes) throws IOException {
        return this.ch.map(FileChannel.MapMode.READ_WRITE, 0L, sizeBytes);
    }

    @Override
    public void force() throws IOException {
        this.force(false);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this.ch.transferTo(position, count, target);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        long written = this.ch.transferFrom(src, position, count);
        if (written > 0L) {
            this.position(position + written);
        }
        return written;
    }
}

