/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client.cache;

import java.util.Map;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientResponse;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;

class ClientCacheInvokeAllResponse
extends ClientResponse {
    private final Map<Object, EntryProcessorResult<Object>> res;

    ClientCacheInvokeAllResponse(long reqId, Map<Object, EntryProcessorResult<Object>> res) {
        super(reqId);
        assert (res != null);
        this.res = res;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        super.encode(ctx, writer);
        writer.writeInt(this.res.size());
        for (Map.Entry<Object, EntryProcessorResult<Object>> entry : this.res.entrySet()) {
            writer.writeObjectDetached(entry.getKey());
            EntryProcessorResult<Object> epRes = entry.getValue();
            try {
                Object val = epRes.get();
                writer.writeBoolean(true);
                writer.writeObjectDetached(val);
            }
            catch (EntryProcessorException e) {
                writer.writeBoolean(false);
                Object msg = e.getMessage();
                if (ctx.kernalContext().clientListener().sendServerExceptionStackTraceToClient()) {
                    msg = (String)msg + U.nl() + X.getFullStackTrace(e);
                }
                writer.writeString((String)msg);
            }
        }
    }
}

