/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.client.handler.requests.sql;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite3.client.handler.ClientHandlerMetricSource;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.async.AsyncResultSet;

class ClientSqlResultSet {
    private final AsyncResultSet<SqlRow> resultSet;
    private final ClientHandlerMetricSource metrics;
    private final AtomicBoolean closed = new AtomicBoolean();

    ClientSqlResultSet(AsyncResultSet<SqlRow> resultSet, ClientHandlerMetricSource metrics) {
        assert (resultSet != null);
        assert (metrics != null);
        this.resultSet = resultSet;
        this.metrics = metrics;
    }

    public AsyncResultSet<SqlRow> resultSet() {
        return this.resultSet;
    }

    public CompletableFuture<Void> closeAsync() {
        if (this.closed.compareAndSet(false, true)) {
            this.metrics.cursorsActiveDecrement();
            return this.resultSet.closeAsync();
        }
        return CompletableFutures.nullCompletedFuture();
    }
}

