/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.recovery.cluster;

import java.util.Objects;
import org.apache.ignite3.internal.cli.commands.recovery.cluster.migrate.MigrateToClusterMixin;
import org.apache.ignite3.internal.cli.core.call.CallInput;

public class MigrateToClusterCallInput
implements CallInput {
    private final String oldClusterUrl;
    private final String newClusterUrl;

    public String oldClusterUrl() {
        return this.oldClusterUrl;
    }

    public String newClusterUrl() {
        return this.newClusterUrl;
    }

    private MigrateToClusterCallInput(String oldClusterUrl, String newClusterUrl) {
        Objects.requireNonNull(oldClusterUrl);
        Objects.requireNonNull(newClusterUrl);
        this.oldClusterUrl = oldClusterUrl;
        this.newClusterUrl = newClusterUrl;
    }

    public static MigrateToClusterCallInput of(MigrateToClusterMixin statesArgs) {
        return MigrateToClusterCallInput.builder().oldClusterUrl(statesArgs.getOldClusterUrl()).newClusterUrl(statesArgs.getNewClusterUrl()).build();
    }

    private static MigrateToClusterCallInputBuilder builder() {
        return new MigrateToClusterCallInputBuilder();
    }

    private static class MigrateToClusterCallInputBuilder {
        private String oldClusterUrl;
        private String newClusterUrl;

        private MigrateToClusterCallInputBuilder() {
        }

        MigrateToClusterCallInputBuilder oldClusterUrl(String oldClusterUrl) {
            this.oldClusterUrl = oldClusterUrl;
            return this;
        }

        MigrateToClusterCallInputBuilder newClusterUrl(String newClusterUrl) {
            this.newClusterUrl = newClusterUrl;
            return this;
        }

        MigrateToClusterCallInput build() {
            return new MigrateToClusterCallInput(this.oldClusterUrl, this.newClusterUrl);
        }
    }
}

