/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.call;

import java.util.concurrent.atomic.AtomicLong;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarBuilder;
import org.apache.ignite3.internal.cli.core.call.ProgressTracker;

public class ProgressBarTracker
implements ProgressTracker {
    private final ProgressBarBuilder progressBarBuilder;
    private final AtomicLong maxSize = new AtomicLong(0L);
    private volatile ProgressBar progressBar;

    ProgressBarTracker(ProgressBarBuilder progressBarBuilder) {
        this.progressBarBuilder = progressBarBuilder;
    }

    @Override
    public synchronized void track(long size) {
        this.ensureProgressBar();
        this.progressBar.stepTo(size);
    }

    @Override
    public void maxSize(long size) {
        this.ensureProgressBar();
        this.maxSize.compareAndSet(0L, size);
        this.progressBar.maxHint(size);
    }

    @Override
    public void done() {
        this.ensureProgressBar();
        this.progressBar.stepTo(this.maxSize.get());
    }

    @Override
    public void close() {
        if (this.progressBar != null) {
            this.progressBar.close();
        }
    }

    private void ensureProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = this.progressBarBuilder.build();
        }
    }
}

