/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl.executor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ignite3.internal.cli.core.repl.completer.DynamicCompleterRegistry;
import org.apache.ignite3.internal.cli.core.repl.completer.filter.CompleterFilter;
import org.jline.builtins.Options;
import org.jline.console.ArgDesc;
import org.jline.console.CmdDesc;
import org.jline.console.CommandRegistry;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.reader.impl.completer.ArgumentCompleter;
import org.jline.reader.impl.completer.NullCompleter;
import org.jline.reader.impl.completer.SystemCompleter;
import org.jline.utils.AttributedString;
import org.jline.utils.StyleResolver;
import picocli.AutoComplete;
import picocli.CommandLine;

public class IgnitePicocliCommands
implements CommandRegistry {
    private final CommandLine cmd;
    private final Set<String> commands;
    private final Map<String, String> aliasCommand = new HashMap<String, String>();
    private final DynamicCompleterRegistry completerRegistry;
    private final List<CompleterFilter> completerFilters;

    public IgnitePicocliCommands(CommandLine cmd, DynamicCompleterRegistry completerRegistry, List<CompleterFilter> completerFilters) {
        this.cmd = cmd;
        this.completerFilters = completerFilters;
        this.completerRegistry = completerRegistry;
        this.commands = cmd.getCommandSpec().subcommands().keySet();
        this.putAliases(cmd);
    }

    private void putAliases(CommandLine cmd) {
        for (String c : this.commands) {
            for (String a : ((CommandLine)cmd.getSubcommands().get(c)).getCommandSpec().aliases()) {
                this.aliasCommand.put(a, c);
            }
        }
    }

    public CommandLine getCmd() {
        return this.cmd;
    }

    public boolean hasCommand(String command) {
        return this.commands.contains(command) || this.aliasCommand.containsKey(command);
    }

    public SystemCompleter compileCompleters() {
        SystemCompleter out = new SystemCompleter();
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.commands);
        all.addAll(this.aliasCommand.keySet());
        out.add(all, (Completer)new IgnitePicocliCompleter());
        return out;
    }

    private CommandLine findSubcommandLine(List<String> args, int lastIdx) {
        CommandLine out = this.cmd;
        for (int i = 0; i < lastIdx && (args.get(i).startsWith("-") || (out = this.findSubcommandLine(out, args.get(i))) != null); ++i) {
        }
        return out;
    }

    private CommandLine findSubcommandLine(CommandLine cmdline, String command) {
        for (CommandLine s : cmdline.getSubcommands().values()) {
            if (!s.getCommandName().equals(command) && !Arrays.asList(s.getCommandSpec().aliases()).contains(command)) continue;
            return s;
        }
        return null;
    }

    public CmdDesc commandDescription(List<String> args) {
        CommandLine sub = this.findSubcommandLine(args, args.size());
        if (sub == null) {
            return null;
        }
        CommandLine.Model.CommandSpec spec = sub.getCommandSpec();
        CommandLine.Help cmdhelp = new CommandLine.Help((Object)spec);
        ArrayList<AttributedString> main = new ArrayList<AttributedString>();
        HashMap options = new HashMap();
        String synopsis = AttributedString.stripAnsi((String)((CommandLine.IHelpSectionRenderer)spec.usageMessage().sectionMap().get("synopsis")).render(cmdhelp));
        main.add(Options.HelpException.highlightSyntax((String)synopsis.trim(), (StyleResolver)Options.HelpException.defaultStyle()));
        for (CommandLine.Model.OptionSpec o : spec.options()) {
            Object key = String.join((CharSequence)" ", o.names());
            ArrayList<AttributedString> val = new ArrayList<AttributedString>();
            for (String d : o.description()) {
                val.add(new AttributedString((CharSequence)d));
            }
            if (o.arity().max() > 0) {
                key = (String)key + "=" + o.paramLabel();
            }
            options.put((String)key, val);
        }
        return new CmdDesc(main, ArgDesc.doArgNames(List.of("")), options);
    }

    public List<String> commandInfo(String command) {
        CommandLine.Model.CommandSpec spec = ((CommandLine)this.cmd.getSubcommands().get(command)).getCommandSpec();
        CommandLine.Help cmdhelp = new CommandLine.Help((Object)spec);
        String description = AttributedString.stripAnsi((String)((CommandLine.IHelpSectionRenderer)spec.usageMessage().sectionMap().get("description")).render(cmdhelp));
        return new ArrayList<String>(Arrays.asList(description.split("\\r?\\n")));
    }

    public Object invoke(CommandRegistry.CommandSession session, String command, Object[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(command);
        Arrays.stream(args).map(Object::toString).forEach(arguments::add);
        this.cmd.execute(arguments.toArray(new String[0]));
        return null;
    }

    public Object executeHelp(Object[] args) {
        return this.invoke(new CommandRegistry.CommandSession(), "help", args);
    }

    public Set<String> commandNames() {
        return this.commands;
    }

    public Map<String, String> commandAliases() {
        return this.aliasCommand;
    }

    private class IgnitePicocliCompleter
    extends ArgumentCompleter {
        public IgnitePicocliCompleter() {
            super(new Completer[]{NullCompleter.INSTANCE});
        }

        public void complete(LineReader reader, ParsedLine commandLine, List<Candidate> candidates) {
            assert (commandLine != null);
            assert (candidates != null);
            String[] words = commandLine.words().toArray(new String[0]);
            ArrayList cs = new ArrayList();
            AutoComplete.complete((CommandLine.Model.CommandSpec)IgnitePicocliCommands.this.cmd.getCommandSpec(), (String[])words, (int)commandLine.wordIndex(), (int)0, (int)commandLine.cursor(), cs);
            try {
                IgnitePicocliCommands.this.completerRegistry.findCompleters(words).stream().map(c -> c.complete(words)).flatMap(Collection::stream).map(this::dynamicCandidate).forEach(candidates::add);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (candidates.isEmpty()) {
                String[] filteredCandidates = (String[])cs.stream().map(CharSequence::toString).toArray(String[]::new);
                for (CompleterFilter filter : IgnitePicocliCommands.this.completerFilters) {
                    filteredCandidates = filter.filter(words, filteredCandidates);
                }
                for (String c2 : filteredCandidates) {
                    candidates.add(this.staticCandidate(c2));
                }
            }
        }

        private Candidate dynamicCandidate(String one) {
            int sortingPriority = one.split("\\.").length;
            return new Candidate(one, one, null, null, null, null, false, sortingPriority);
        }

        private Candidate staticCandidate(String one) {
            return new Candidate(one, one, null, null, null, null, true, 10);
        }
    }
}

