/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.dsl;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.metastorage.dsl.ConditionType;
import org.apache.ignite3.internal.metastorage.dsl.MetaStorageMessagesFactory;
import org.apache.ignite3.internal.metastorage.dsl.SimpleCondition;
import org.apache.ignite3.internal.metastorage.dsl.ValueConditionBuilder;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;

class ValueConditionDeserializer
implements MessageDeserializer<SimpleCondition.ValueCondition> {
    private final ValueConditionBuilder msg;

    ValueConditionDeserializer(MetaStorageMessagesFactory messageFactory) {
        this.msg = messageFactory.valueCondition();
    }

    @Override
    public Class<SimpleCondition.ValueCondition> klass() {
        return SimpleCondition.ValueCondition.class;
    }

    @Override
    public SimpleCondition.ValueCondition getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                ByteBuffer tmp = reader.readByteBuffer("key");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.key(tmp);
                reader.incrementState();
            }
            case 1: {
                int shiftedId = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                ConditionType tmp = shiftedId == 0 ? null : ConditionType.fromId(shiftedId - 1);
                this.msg.type(tmp);
                reader.incrementState();
            }
            case 2: {
                ByteBuffer tmp = reader.readByteBuffer("value");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.value(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SimpleCondition.ValueCondition.class);
    }
}

