/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network;

import org.apache.ignite3.internal.network.NetworkConfigurationException;
import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializationFactory;
import org.apache.ignite3.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;

public class MessageSerializationRegistryImpl
implements MessageSerializationRegistry {
    private final MessageSerializationFactory<?>[][] factories = new MessageSerializationFactory[32768][];

    @Override
    public MessageSerializationRegistry registerFactory(short groupType, short messageType, MessageSerializationFactory<?> factory) {
        assert (groupType >= 0) : "group type must not be negative";
        assert (messageType >= 0) : "message type must not be negative";
        MessageSerializationFactory<?>[] groupFactories = this.factories[groupType];
        if (groupFactories == null) {
            groupFactories = new MessageSerializationFactory[32768];
            this.factories[groupType] = groupFactories;
        } else if (groupFactories[messageType] != null) {
            throw new NetworkConfigurationException(String.format("Message serialization factory for message type %d in module %d is already defined", messageType, groupType));
        }
        groupFactories[messageType] = factory;
        return this;
    }

    private <T extends NetworkMessage> MessageSerializationFactory<T> getFactory(short groupType, short messageType) {
        MessageSerializationFactory<?> provider;
        if (groupType < 0) {
            throw new NetworkConfigurationException("Group type must not be negative, groupType=" + groupType);
        }
        if (messageType < 0) {
            throw new NetworkConfigurationException("Message type must not be negative, messageType=" + messageType);
        }
        MessageSerializationFactory<?>[] groupFactories = this.factories[groupType];
        MessageSerializationFactory<?> messageSerializationFactory = provider = groupFactories == null ? null : groupFactories[messageType];
        if (provider == null) {
            throw new NetworkConfigurationException(String.format("No serializer provider defined for group type %d and message type %d", groupType, messageType));
        }
        return provider;
    }

    @Override
    public <T extends NetworkMessage> MessageSerializer<T> createSerializer(short groupType, short messageType) {
        MessageSerializationFactory<T> factory = this.getFactory(groupType, messageType);
        return factory.createSerializer();
    }

    @Override
    public <T extends NetworkMessage> MessageDeserializer<T> createDeserializer(short groupType, short messageType) {
        MessageSerializationFactory<T> factory = this.getFactory(groupType, messageType);
        return factory.createDeserializer();
    }
}

