/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.raft.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommand;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV1;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV2;
import org.apache.ignite3.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite3.internal.partition.replicator.raft.RaftTxFinishMarker;
import org.apache.ignite3.internal.partition.replicator.raft.UnexpectedTransactionStateException;
import org.apache.ignite3.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.message.TablePartitionIdMessage;
import org.apache.ignite3.internal.tx.TransactionResult;
import org.apache.ignite3.internal.tx.TxManager;
import org.apache.ignite3.internal.tx.TxMeta;
import org.apache.ignite3.internal.tx.TxState;
import org.apache.ignite3.internal.tx.impl.EnlistedPartitionGroup;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite3.internal.tx.storage.state.TxStatePartitionStorage;
import org.jetbrains.annotations.Nullable;

public class FinishTxCommandHandler
extends AbstractCommandHandler<FinishTxCommand> {
    private static final IgniteLogger LOG = Loggers.forClass(FinishTxCommandHandler.class);
    private final TxStatePartitionStorage txStatePartitionStorage;
    private final ReplicationGroupId replicationGroupId;
    private final RaftTxFinishMarker txFinishMarker;

    public FinishTxCommandHandler(TxStatePartitionStorage txStatePartitionStorage, ReplicationGroupId replicationGroupId, TxManager txManager) {
        this.txStatePartitionStorage = txStatePartitionStorage;
        this.replicationGroupId = replicationGroupId;
        this.txFinishMarker = new RaftTxFinishMarker(txManager);
    }

    @Override
    protected CommandResult handleInternally(FinishTxCommand command, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) throws IgniteInternalException {
        if (commandIndex <= this.txStatePartitionStorage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        UUID txId = command.txId();
        TxState stateToSet = command.commit() ? TxState.COMMITTED : TxState.ABORTED;
        TxMeta txMetaToSet = new TxMeta(stateToSet, FinishTxCommandHandler.enlistedPartitions(command), command.commitTimestamp());
        TxMeta txMetaBeforeCas = this.txStatePartitionStorage.get(txId);
        boolean txStateChangeRes = this.txStatePartitionStorage.compareAndSet(txId, null, txMetaToSet, commandIndex, commandTerm);
        this.txFinishMarker.markFinished(txId, command.commit(), command.commitTimestamp(), this.replicationGroupId);
        LOG.debug("Finish the transaction txId = {}, state = {}, txStateChangeRes = {}", txId, txMetaToSet, txStateChangeRes);
        if (!txStateChangeRes) {
            assert (txMetaBeforeCas != null) : "txMetaBeforeCase is null, but CAS has failed for " + txId;
            FinishTxCommandHandler.onTxStateStorageCasFail(txId, txMetaBeforeCas, txMetaToSet);
        }
        return new CommandResult(new TransactionResult(stateToSet, command.commitTimestamp()), true);
    }

    private static List<EnlistedPartitionGroup> fromPartitionMessages(List<EnlistedPartitionGroupMessage> messages) {
        ArrayList<EnlistedPartitionGroup> list = new ArrayList<EnlistedPartitionGroup>(messages.size());
        for (EnlistedPartitionGroupMessage message : messages) {
            list.add(message.asPartitionInfo());
        }
        return list;
    }

    private static void onTxStateStorageCasFail(UUID txId, TxMeta txMetaBeforeCas, TxMeta txMetaToSet) {
        String errorMsg = IgniteStringFormatter.format("Failed to update tx state in the storage, transaction txId = {} because of inconsistent state, expected state = {}, state to set = {}", txId, txMetaBeforeCas, txMetaToSet);
        UnexpectedTransactionStateException stateChangeException = new UnexpectedTransactionStateException(errorMsg, new TransactionResult(txMetaBeforeCas.txState(), txMetaBeforeCas.commitTimestamp()));
        LOG.error(errorMsg, new Object[0]);
        throw stateChangeException;
    }

    private static List<EnlistedPartitionGroup> enlistedPartitions(FinishTxCommand command) {
        if (command instanceof FinishTxCommandV2) {
            return FinishTxCommandHandler.fromPartitionMessages(((FinishTxCommandV2)command).partitions());
        }
        if (command instanceof FinishTxCommandV1) {
            return FinishTxCommandHandler.enlistedPartitions((FinishTxCommandV1)command);
        }
        throw new IllegalArgumentException("Unknown command: " + command);
    }

    private static List<EnlistedPartitionGroup> enlistedPartitions(FinishTxCommandV1 command) {
        return command.partitionIds().stream().map(TablePartitionIdMessage::asTablePartitionId).map(EnlistedPartitionGroup::new).collect(Collectors.toList());
    }
}

