/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.ignite3.internal.table.AntiHijackAsyncCursor;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.sql.ResultSetMetadata;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.jetbrains.annotations.Nullable;

public class AntiHijackAsyncResultSet<T>
extends AntiHijackAsyncCursor<T>
implements AsyncResultSet<T>,
Wrapper {
    private final AsyncResultSet<T> resultSet;
    private final Executor asyncContinuationExecutor;

    AntiHijackAsyncResultSet(AsyncResultSet<T> resultSet, Executor asyncContinuationExecutor) {
        super(resultSet, asyncContinuationExecutor);
        this.resultSet = resultSet;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    @Nullable
    public ResultSetMetadata metadata() {
        return this.resultSet.metadata();
    }

    @Override
    public boolean hasRowSet() {
        return this.resultSet.hasRowSet();
    }

    @Override
    public long affectedRows() {
        return this.resultSet.affectedRows();
    }

    @Override
    public boolean wasApplied() {
        return this.resultSet.wasApplied();
    }

    @Override
    public CompletableFuture<? extends AsyncResultSet<T>> fetchNextPage() {
        return PublicApiThreading.preventThreadHijack(this.resultSet.fetchNextPage(), this.asyncContinuationExecutor).thenApply(resultSet -> new AntiHijackAsyncResultSet<T>(resultSet, this.asyncContinuationExecutor));
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.resultSet);
    }
}

