/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.api;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.apache.ignite3.internal.sql.api.AntiHijackAsyncResultSet;
import org.apache.ignite3.internal.thread.PublicApiThreading;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.apache.ignite3.internal.wrapper.Wrappers;
import org.apache.ignite3.lang.CancellationToken;
import org.apache.ignite3.sql.BatchedArguments;
import org.apache.ignite3.sql.IgniteSql;
import org.apache.ignite3.sql.ResultSet;
import org.apache.ignite3.sql.SqlRow;
import org.apache.ignite3.sql.Statement;
import org.apache.ignite3.sql.async.AsyncResultSet;
import org.apache.ignite3.table.mapper.Mapper;
import org.apache.ignite3.tx.Transaction;
import org.jetbrains.annotations.Nullable;

public class PublicApiThreadingIgniteSql
implements IgniteSql,
Wrapper {
    private final IgniteSql sql;
    private final Executor asyncContinuationExecutor;

    public PublicApiThreadingIgniteSql(IgniteSql sql, Executor asyncContinuationExecutor) {
        this.sql = sql;
        this.asyncContinuationExecutor = asyncContinuationExecutor;
    }

    @Override
    public Statement createStatement(String query) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.createStatement(query));
    }

    @Override
    public Statement.StatementBuilder statementBuilder() {
        return PublicApiThreading.execUserSyncOperation(this.sql::statementBuilder);
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, cancellationToken, query, arguments));
    }

    @Override
    public ResultSet<SqlRow> execute(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, cancellationToken, statement, arguments));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, mapper, cancellationToken, query, arguments));
    }

    @Override
    public <T> ResultSet<T> execute(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.execute(transaction, mapper, cancellationToken, statement, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, cancellationToken, query, arguments));
    }

    @Override
    public CompletableFuture<AsyncResultSet<SqlRow>> executeAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, cancellationToken, statement, arguments));
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, mapper, cancellationToken, query, arguments));
    }

    @Override
    public <T> CompletableFuture<AsyncResultSet<T>> executeAsync(@Nullable Transaction transaction, @Nullable Mapper<T> mapper, @Nullable CancellationToken cancellationToken, Statement statement, Object ... arguments) {
        return this.doAsyncOperationForResultSet(() -> this.sql.executeAsync(transaction, mapper, cancellationToken, statement, arguments));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String dmlQuery, BatchedArguments batch) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.executeBatch(transaction, cancellationToken, dmlQuery, batch));
    }

    @Override
    public long[] executeBatch(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement dmlStatement, BatchedArguments batch) {
        return PublicApiThreading.execUserSyncOperation(() -> this.sql.executeBatch(transaction, cancellationToken, dmlStatement, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, String query, BatchedArguments batch) {
        return this.doAsyncOperation(() -> this.sql.executeBatchAsync(transaction, cancellationToken, query, batch));
    }

    @Override
    public CompletableFuture<long[]> executeBatchAsync(@Nullable Transaction transaction, @Nullable CancellationToken cancellationToken, Statement statement, BatchedArguments batch) {
        return this.doAsyncOperation(() -> this.sql.executeBatchAsync(transaction, cancellationToken, statement, batch));
    }

    @Override
    public void executeScript(String query, Object ... arguments) {
        PublicApiThreading.execUserSyncOperation(() -> this.sql.executeScript(query, arguments));
    }

    @Override
    public void executeScript(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        PublicApiThreading.execUserSyncOperation(() -> this.sql.executeScript(cancellationToken, query, arguments));
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(String query, Object ... arguments) {
        return this.doAsyncOperation(() -> this.sql.executeScriptAsync(query, arguments));
    }

    @Override
    public CompletableFuture<Void> executeScriptAsync(@Nullable CancellationToken cancellationToken, String query, Object ... arguments) {
        return this.doAsyncOperation(() -> this.sql.executeScriptAsync(cancellationToken, query, arguments));
    }

    private <T> CompletableFuture<AsyncResultSet<T>> doAsyncOperationForResultSet(Supplier<CompletableFuture<AsyncResultSet<T>>> operation) {
        return this.doAsyncOperation(operation).thenApply(resultSet -> new AntiHijackAsyncResultSet(resultSet, this.asyncContinuationExecutor));
    }

    private <T> CompletableFuture<T> doAsyncOperation(Supplier<CompletableFuture<T>> operation) {
        CompletableFuture<T> future = PublicApiThreading.execUserAsyncOperation(operation);
        return PublicApiThreading.preventThreadHijack(future, this.asyncContinuationExecutor);
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return Wrappers.unwrap(this.sql, classToUnwrap);
    }
}

