/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.Objects;
import java.util.function.Supplier;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.hlc.ClockService;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaManager;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTable;
import org.apache.ignite3.internal.sql.engine.exec.ExecutableTableRegistry;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTableImpl;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverter;
import org.apache.ignite3.internal.sql.engine.exec.TableRowConverterFactoryImpl;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTable;
import org.apache.ignite3.internal.sql.engine.exec.UpdatableTableImpl;
import org.apache.ignite3.internal.sql.engine.schema.IgniteTable;
import org.apache.ignite3.internal.sql.engine.schema.PartitionCalculator;
import org.apache.ignite3.internal.sql.engine.schema.SqlSchemaManager;
import org.apache.ignite3.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite3.internal.sql.engine.util.cache.Cache;
import org.apache.ignite3.internal.sql.engine.util.cache.CacheFactory;
import org.apache.ignite3.internal.table.InternalTable;
import org.apache.ignite3.internal.table.TableViewInternal;
import org.apache.ignite3.internal.table.distributed.TableManager;

public class ExecutableTableRegistryImpl
implements ExecutableTableRegistry {
    private final TableManager tableManager;
    private final SqlSchemaManager sqlSchemaManager;
    private final SchemaManager schemaManager;
    private final ReplicaService replicaService;
    private final ClockService clockService;
    private final NodeProperties nodeProperties;
    final Cache<CacheKey, ExecutableTable> tableCache;

    public ExecutableTableRegistryImpl(TableManager tableManager, SchemaManager schemaManager, SqlSchemaManager sqlSchemaManager, ReplicaService replicaService, ClockService clockService, NodeProperties nodeProperties, int cacheSize, CacheFactory cacheFactory) {
        this.sqlSchemaManager = sqlSchemaManager;
        this.tableManager = tableManager;
        this.schemaManager = schemaManager;
        this.replicaService = replicaService;
        this.clockService = clockService;
        this.nodeProperties = nodeProperties;
        this.tableCache = cacheFactory.create(cacheSize);
    }

    @Override
    public ExecutableTable getTable(int catalogVersion, int tableId) {
        IgniteTable sqlTable = this.sqlSchemaManager.table(catalogVersion, tableId);
        return this.tableCache.get(ExecutableTableRegistryImpl.cacheKey(tableId, sqlTable.version()), k -> this.loadTable(sqlTable));
    }

    private ExecutableTable loadTable(IgniteTable sqlTable) {
        TableViewInternal table = this.tableManager.cachedTable(sqlTable.id());
        assert (table != null) : "Table not found: tableId=" + sqlTable.id();
        TableDescriptor tableDescriptor = sqlTable.descriptor();
        SchemaRegistry schemaRegistry = this.schemaManager.schemaRegistry(sqlTable.id());
        SchemaDescriptor schemaDescriptor = schemaRegistry.schema(sqlTable.version());
        TableRowConverterFactoryImpl converterFactory = new TableRowConverterFactoryImpl(tableDescriptor, schemaRegistry, schemaDescriptor);
        InternalTable internalTable = table.internalTable();
        ScannableTableImpl scannableTable = new ScannableTableImpl(internalTable, converterFactory);
        TableRowConverter rowConverter = converterFactory.create(null);
        UpdatableTableImpl updatableTable = new UpdatableTableImpl(sqlTable.id(), sqlTable.zoneId(), tableDescriptor, internalTable.partitions(), internalTable, this.replicaService, this.clockService, this.nodeProperties, rowConverter);
        return new ExecutableTableImpl(scannableTable, updatableTable, sqlTable.partitionCalculator());
    }

    private static CacheKey cacheKey(int tableId, int version) {
        return new CacheKey(tableId, version);
    }

    private static class CacheKey {
        private final int tableId;
        private final int tableVersion;

        CacheKey(int tableId, int tableVersion) {
            this.tableId = tableId;
            this.tableVersion = tableVersion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.tableVersion == cacheKey.tableVersion && this.tableId == cacheKey.tableId;
        }

        public int hashCode() {
            return Objects.hash(this.tableVersion, this.tableId);
        }
    }

    private static final class ExecutableTableImpl
    implements ExecutableTable {
        private final ScannableTable scannableTable;
        private final UpdatableTable updatableTable;
        private final Supplier<PartitionCalculator> partitionCalculator;

        private ExecutableTableImpl(ScannableTable scannableTable, UpdatableTable updatableTable, Supplier<PartitionCalculator> partitionCalculator) {
            this.scannableTable = scannableTable;
            this.updatableTable = updatableTable;
            this.partitionCalculator = partitionCalculator;
        }

        @Override
        public ScannableTable scannableTable() {
            return this.scannableTable;
        }

        @Override
        public UpdatableTable updatableTable() {
            return this.updatableTable;
        }

        @Override
        public TableDescriptor tableDescriptor() {
            return this.updatableTable.descriptor();
        }

        @Override
        public Supplier<PartitionCalculator> partitionCalculator() {
            return this.partitionCalculator;
        }
    }
}

