/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.lang.IgniteStringBuilder;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AccumulatorWrapper;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AccumulatorsState;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AggregateRow;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.AggregateType;
import org.apache.ignite3.internal.sql.engine.exec.exp.agg.GroupKey;
import org.apache.ignite3.internal.sql.engine.exec.rel.AbstractNode;
import org.apache.ignite3.internal.sql.engine.exec.rel.Downstream;
import org.apache.ignite3.internal.sql.engine.exec.rel.SingleNode;
import org.apache.ignite3.internal.util.CollectionUtils;

public class HashAggregateNode<RowT>
extends AbstractNode<RowT>
implements SingleNode<RowT>,
Downstream<RowT> {
    private final AggregateType type;
    private final RowHandler.RowFactory<RowT> rowFactory;
    private final ImmutableBitSet allFields;
    private final List<Grouping> groupings;
    private final List<AccumulatorWrapper<RowT>> accs;
    private int requested;
    private int waiting;
    private boolean inLoop;

    public HashAggregateNode(ExecutionContext<RowT> ctx, AggregateType type, List<ImmutableBitSet> grpSets, List<AccumulatorWrapper<RowT>> accumulators, RowHandler.RowFactory<RowT> rowFactory) {
        super(ctx);
        this.type = type;
        this.rowFactory = rowFactory;
        assert (grpSets.size() <= 127) : "Too many grouping sets";
        ImmutableBitSet.Builder b = ImmutableBitSet.builder();
        this.groupings = new ArrayList<Grouping>(grpSets.size());
        this.accs = accumulators;
        for (byte i = 0; i < grpSets.size(); i = (byte)(i + 1)) {
            ImmutableBitSet grpFields = grpSets.get(i);
            b.addAll(grpFields);
            Grouping grouping = new Grouping(i, grpFields);
            grouping.init();
            this.groupings.add(grouping);
        }
        this.allFields = b.build();
    }

    @Override
    public void request(int rowsCnt) throws Exception {
        assert (!CollectionUtils.nullOrEmpty(this.sources()) && this.sources().size() == 1);
        assert (rowsCnt > 0 && this.requested == 0);
        assert (this.waiting <= 0);
        this.requested = rowsCnt;
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        } else if (!this.inLoop) {
            this.execute(this::doFlush);
        }
    }

    @Override
    public void push(RowT row) throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        --this.waiting;
        for (Grouping grouping : this.groupings) {
            grouping.add(row);
        }
        if (this.waiting == 0) {
            this.waiting = this.inBufSize;
            this.source().request(this.waiting);
        }
    }

    @Override
    public void end() throws Exception {
        assert (this.downstream() != null);
        assert (this.waiting > 0);
        this.waiting = -1;
        this.flush();
    }

    @Override
    protected void rewindInternal() {
        this.requested = 0;
        this.waiting = 0;
        this.groupings.forEach(rec$ -> ((Grouping)rec$).reset());
    }

    @Override
    protected Downstream<RowT> requestDownstream(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    protected void dumpDebugInfo0(IgniteStringBuilder buf) {
        buf.app("class=").app(this.getClass().getSimpleName()).app(", requested=").app(this.requested).app(", waiting=").app(this.waiting);
    }

    private void doFlush() throws Exception {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws Exception {
        assert (this.waiting == -1);
        int processed = 0;
        ArrayDeque<Grouping> groupingsQueue = this.groupingsQueue();
        this.inLoop = true;
        try {
            while (this.requested > 0 && !groupingsQueue.isEmpty()) {
                Grouping grouping = groupingsQueue.peek();
                int toSnd = Math.min(this.requested, this.inBufSize - processed);
                for (Object row : grouping.getRows(toSnd)) {
                    --this.requested;
                    this.downstream().push(row);
                    ++processed;
                }
                if (processed >= this.inBufSize && this.requested > 0) {
                    this.execute(this::doFlush);
                    return;
                }
                if (!grouping.isEmpty()) continue;
                groupingsQueue.remove();
            }
        }
        finally {
            this.inLoop = false;
        }
        if (this.requested > 0) {
            this.requested = 0;
            this.downstream().end();
        }
    }

    private ArrayDeque<Grouping> groupingsQueue() {
        return this.groupings.stream().filter(g -> !g.isEmpty()).collect(Collectors.toCollection(ArrayDeque::new));
    }

    private class Grouping {
        private final byte grpId;
        private final ImmutableBitSet grpFields;
        private final Map<GroupKey, AggregateRow<RowT>> groups = new HashMap();

        private Grouping(byte grpId, ImmutableBitSet grpFields) {
            this.grpId = grpId;
            this.grpFields = grpFields;
        }

        private void init() {
            if (AggregateRow.addEmptyGroup(this.grpFields, HashAggregateNode.this.type)) {
                this.groups.put(GroupKey.EMPTY_GRP_KEY, this.create());
            }
        }

        private void reset() {
            this.groups.clear();
            this.init();
        }

        private void add(RowT row) {
            RowHandler handler = HashAggregateNode.this.context().rowHandler();
            if (!AggregateRow.groupMatches(handler, row, HashAggregateNode.this.type, this.grpId)) {
                return;
            }
            GroupKey.Builder b = GroupKey.builder(this.grpFields.cardinality());
            Iterator iterator = this.grpFields.iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                b.add(handler.get(field, row));
            }
            GroupKey grpKey = b.build();
            AggregateRow aggRow = this.groups.computeIfAbsent(grpKey, k -> this.create());
            aggRow.update(HashAggregateNode.this.accs, this.grpFields, handler, row);
        }

        private List<RowT> getRows(int cnt) {
            Iterator it = this.groups.entrySet().iterator();
            int rowNum = Math.min(cnt, this.groups.size());
            ArrayList res = new ArrayList(rowNum);
            for (int i = 0; i < rowNum; ++i) {
                Map.Entry entry = it.next();
                GroupKey grpKey = entry.getKey();
                AggregateRow aggRow = entry.getValue();
                Object[] fields = aggRow.createOutput(HashAggregateNode.this.type, HashAggregateNode.this.accs, HashAggregateNode.this.allFields, this.grpId);
                int j = 0;
                int k = 0;
                Iterator iterator = HashAggregateNode.this.allFields.iterator();
                while (iterator.hasNext()) {
                    int field = (Integer)iterator.next();
                    fields[j++] = this.grpFields.get(field) ? grpKey.field(k++) : null;
                }
                aggRow.writeTo(HashAggregateNode.this.type, HashAggregateNode.this.accs, fields, HashAggregateNode.this.allFields.cardinality(), this.grpFields, this.grpId);
                Object row = HashAggregateNode.this.rowFactory.create(fields);
                res.add(row);
                it.remove();
            }
            return res;
        }

        private AggregateRow<RowT> create() {
            Int2ObjectArrayMap distinctSets = new Int2ObjectArrayMap();
            for (int i = 0; i < HashAggregateNode.this.accs.size(); ++i) {
                AccumulatorWrapper acc = HashAggregateNode.this.accs.get(i);
                if (!acc.isDistinct()) continue;
                distinctSets.put(i, new HashSet());
            }
            AccumulatorsState state = new AccumulatorsState(HashAggregateNode.this.accs.size());
            return new AggregateRow(state, (Int2ObjectMap<Set<Object>>)distinctSets);
        }

        private boolean isEmpty() {
            return this.groups.isEmpty();
        }
    }
}

