/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.agg;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.ignite3.internal.sql.engine.metadata.cost.IgniteCostFactory;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRelVisitor;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteHashAggregateBase;
import org.apache.ignite3.internal.sql.engine.rel.agg.IgniteReduceAggregateBase;

public class IgniteReduceHashAggregate
extends IgniteReduceAggregateBase
implements IgniteHashAggregateBase {
    private static final String REL_TYPE_NAME = "ReduceHashAggregate";

    public IgniteReduceHashAggregate(RelOptCluster cluster, RelTraitSet traits, RelNode input, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls, RelDataType rowType) {
        super(cluster, traits, input, groupSet, groupSets, aggCalls, rowType);
    }

    public IgniteReduceHashAggregate(RelInput input) {
        super(input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new IgniteReduceHashAggregate(this.getCluster(), traitSet, (RelNode)IgniteReduceHashAggregate.sole(inputs), this.groupSet, this.groupSets, this.aggCalls, this.rowType);
    }

    @Override
    public IgniteRel clone(RelOptCluster cluster, List<IgniteRel> inputs) {
        return new IgniteReduceHashAggregate(cluster, this.getTraitSet(), (RelNode)IgniteReduceHashAggregate.sole(inputs), this.groupSet, this.groupSets, this.aggCalls, this.rowType);
    }

    @Override
    public <T> T accept(IgniteRelVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        IgniteCostFactory costFactory = (IgniteCostFactory)planner.getCostFactory();
        double rows = mq.getRowCount(this.getInput());
        double mem = 0.0;
        if (this.aggCalls.isEmpty()) {
            mem = (double)this.groupSet.cardinality() * 4.0;
        } else {
            for (AggregateCall aggCall : this.aggCalls) {
                if (aggCall.isDistinct()) {
                    mem += 5.0 * rows;
                    continue;
                }
                mem += 5.0;
            }
        }
        return costFactory.makeCost(rows, rows * 1.0, 0.0, mem, 0.0);
    }

    @Override
    public List<Pair<RelTraitSet, List<RelTraitSet>>> deriveCollation(RelTraitSet nodeTraits, List<RelTraitSet> inTraits) {
        return List.of(Pair.of((Object)nodeTraits.replace((RelTrait)RelCollations.EMPTY), List.of(inTraits.get(0).replace((RelTrait)RelCollations.EMPTY))));
    }

    public String getRelTypeName() {
        return REL_TYPE_NAME;
    }
}

