/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.sql.engine.prepare.IgniteSqlValidator;

public interface IgniteResource {
    public static final IgniteResource INSTANCE = (IgniteResource)Resources.create(IgniteResource.class);

    @Resources.BaseMessage(value="Illegal alias. {0} is reserved name")
    public Resources.ExInst<SqlValidatorException> illegalAlias(String var1);

    @Resources.BaseMessage(value="Cannot update field \"{0}\". Primary key columns are not modifiable")
    public Resources.ExInst<SqlValidatorException> cannotUpdateField(String var1);

    @Resources.BaseMessage(value="Illegal aggregate function. {0} is unsupported at the moment")
    public Resources.ExInst<SqlValidatorException> unsupportedAggregationFunction(String var1);

    @Resources.BaseMessage(value="Illegal value of {0}. The value must be positive and less than 9223372036854775807")
    public Resources.ExInst<SqlValidatorException> illegalFetchLimit(String var1);

    @Resources.BaseMessage(value="Invalid decimal literal")
    public Resources.ExInst<SqlValidatorException> decimalLiteralInvalid();

    @Resources.BaseMessage(value="Values passed to {0} operator must have compatible types. Dynamic parameter requires adding explicit type cast")
    public Resources.ExInst<SqlValidatorException> operationRequiresExplicitCast(String var1);

    @Resources.BaseMessage(value="Assignment from {0} to {1} can not be performed. Dynamic parameter requires adding explicit type cast")
    public Resources.ExInst<SqlValidatorException> assignmentRequiresExplicitCast(String var1, String var2);

    @Resources.BaseMessage(value="System view {0} is not modifiable")
    public Resources.ExInst<SqlValidatorException> systemViewIsNotModifiable(String var1);

    @Resources.BaseMessage(value="Ambiguous operator {0}. Dynamic parameter requires adding explicit type cast")
    public Resources.ExInst<SqlValidatorException> ambiguousOperator1(String var1);

    @Resources.BaseMessage(value="Ambiguous operator {0}. Dynamic parameter requires adding explicit type cast. Supported form(s): \n{1}")
    public Resources.ExInst<SqlValidatorException> ambiguousOperator2(String var1, String var2);

    @Resources.BaseMessage(value="Unable to determine type of a dynamic parameter. Dynamic parameter requires adding explicit type cast")
    public Resources.ExInst<SqlValidatorException> unableToResolveDynamicParameterType();

    @Resources.BaseMessage(value="Incorrect type of a dynamic parameter. Expected <{0}> but got <{1}>")
    public Resources.ExInst<SqlValidatorException> incorrectDynamicParameterType(String var1, String var2);

    @Resources.BaseMessage(value="Expression is not supported: {0}")
    public Resources.ExInst<SqlValidatorException> unsupportedExpression(String var1);

    @Resources.BaseMessage(value="CHAR datatype is not supported in table")
    public Resources.ExInst<SqlValidatorException> charDataTypeIsNotSupportedInTable();

    @Resources.BaseMessage(value="BINARY datatype is not supported in table")
    public Resources.ExInst<SqlValidatorException> binaryDataTypeIsNotSupportedInTable();

    @Resources.BaseMessage(value="{0} datatype is not supported'")
    public Resources.ExInst<SqlValidatorException> dataTypeIsNotSupported(String var1);

    @Resources.BaseMessage(value="{0} length {1,number,#} must be between {2,number,#} and {3,number,#}.")
    public Resources.ExInst<SqlValidatorException> invalidLengthForType(String var1, int var2, int var3, int var4);

    @Resources.BaseMessage(value="{0} precision {1,number,#} must be between {2,number,#} and {3,number,#}.")
    public Resources.ExInst<SqlValidatorException> invalidPrecisionForType(String var1, int var2, int var3, int var4);

    @Resources.BaseMessage(value="{0} scale {1,number,#} must be between {2,number,#} and {3,number,#}.")
    public Resources.ExInst<SqlValidatorException> invalidScaleForType(String var1, int var2, int var3, int var4);

    @Resources.BaseMessage(value="Column N#{0} matched using NATURAL keyword or USING clause has incompatible types in this context: ''{1}'' to ''{2}''")
    public Resources.ExInst<SqlValidatorException> naturalOrUsingColumnNotCompatible(int var1, String var2, String var3);

    @Resources.BaseMessage(value="Cannot apply ''{0}'' to arguments of type {1}.")
    public Resources.ExInst<SqlValidatorException> canNotApplyOp2Type(String var1, String var2);

    @Resources.BaseMessage(value="A recursive query is not supported.")
    public Resources.ExInst<SqlValidatorException> recursiveQueryIsNotSupported();

    @Resources.BaseMessage(value="Unexpected statement: {0} ")
    public Resources.ExInst<CalciteException> unexpectedStatement(String var1);

    @Resources.BaseMessage(value="Timestamp literal ''{0}'' out of range.")
    public Resources.ExInst<SqlValidatorException> timestampLiteralOutOfRange(String var1);

    @Resources.BaseMessage(value="Invalid number of arguments to function ''{0}''. Was expecting number of arguments in range [{1,number,#}, {2,number,#}].")
    public Resources.ExInst<SqlValidatorException> invalidArgCount(String var1, int var2, int var3);

    public static String makeSignature(SqlCallBinding binding, RelDataType ... operandTypes) {
        return IgniteResource.makeSignature(binding, Arrays.asList(operandTypes));
    }

    public static String makeSignature(SqlCallBinding binding, List<RelDataType> operandTypes) {
        IgniteSqlValidator validator = (IgniteSqlValidator)binding.getValidator();
        List operandList = binding.getCall().getOperandList();
        return IgniteResource.makeSignature(binding.getOperator(), validator, operandList, operandTypes);
    }

    public static String makeSignature(SqlOperator operator, IgniteSqlValidator validator, List<SqlNode> operands, List<RelDataType> originalOperandTypes) {
        ArrayList<String> operandTypeNames = new ArrayList<String>(originalOperandTypes.size());
        for (int i = 0; i < operands.size(); ++i) {
            SqlNode node = operands.get(i);
            RelDataType dataType = validator.isUnspecifiedDynamicParam(node) ? validator.getUnknownType() : originalOperandTypes.get(i);
            operandTypeNames.add(IgniteStringFormatter.format("<{}>", dataType));
        }
        SqlKind kind = operator.getKind();
        if (SqlKind.BINARY_ARITHMETIC.contains(kind) || SqlKind.BINARY_COMPARISON.contains(kind)) {
            return IgniteStringFormatter.format("{} {} {}", operandTypeNames.get(0), operator.getName(), operandTypeNames.get(1));
        }
        if (operator.getName().startsWith("IS ")) {
            return IgniteStringFormatter.format("{} {}", operandTypeNames.get(0), operator.getName());
        }
        if (kind == SqlKind.BETWEEN) {
            return IgniteStringFormatter.format("{} {} AND {}", operator.getName(), operandTypeNames.get(0), operandTypeNames.get(1));
        }
        if (kind == SqlKind.MINUS_PREFIX) {
            return IgniteStringFormatter.format("{}{}", operator.getName(), operandTypeNames.get(0));
        }
        String operandStr = String.join((CharSequence)", ", operandTypeNames);
        return IgniteStringFormatter.format("{}({})", operator.getName(), operandStr);
    }
}

