/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.pagememory;

import org.apache.ignite3.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite3.internal.lang.IgniteSystemProperties;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.pagememory.DataRegion;
import org.apache.ignite3.internal.pagememory.PageMemory;
import org.apache.ignite3.internal.pagememory.configuration.VolatileDataRegionConfiguration;
import org.apache.ignite3.internal.pagememory.freelist.FreeListImpl;
import org.apache.ignite3.internal.pagememory.inmemory.VolatilePageMemory;
import org.apache.ignite3.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite3.internal.pagememory.reuse.ReuseList;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.engine.StorageEngine;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileConfiguration;
import org.apache.ignite3.internal.storage.pagememory.configuration.schema.VolatilePageMemoryProfileView;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.apache.ignite3.internal.util.OffheapReadWriteLock;

public class VolatilePageMemoryDataRegion
implements DataRegion<VolatilePageMemory> {
    private static final IgniteLogger LOG = Loggers.forClass(VolatilePageMemoryDataRegion.class);
    private static final String IGNITE_OFFHEAP_LOCK_CONCURRENCY_LEVEL = "IGNITE_OFFHEAP_LOCK_CONCURRENCY_LEVEL";
    private static final int FREE_LIST_GROUP_ID = 0;
    private static final int FREE_LIST_PARTITION_ID = 0;
    private final VolatilePageMemoryProfileConfiguration cfg;
    private final PageIoRegistry ioRegistry;
    private final int pageSize;
    private volatile VolatilePageMemory pageMemory;
    private volatile FreeListImpl freeList;

    VolatilePageMemoryDataRegion(VolatilePageMemoryProfileConfiguration cfg, PageIoRegistry ioRegistry, int pageSize) {
        this.cfg = cfg;
        this.ioRegistry = ioRegistry;
        this.pageSize = pageSize;
    }

    public void start() {
        int lockConcLvl = IgniteSystemProperties.getInteger(IGNITE_OFFHEAP_LOCK_CONCURRENCY_LEVEL, Integer.highestOneBit(Runtime.getRuntime().availableProcessors() * 4));
        VolatileDataRegionConfiguration cfg = VolatilePageMemoryDataRegion.regionConfiguration(this.cfg, this.pageSize);
        VolatilePageMemory pageMemory = new VolatilePageMemory(cfg, this.ioRegistry, new OffheapReadWriteLock(lockConcLvl));
        pageMemory.start();
        try {
            this.freeList = VolatilePageMemoryDataRegion.createFreeList(pageMemory);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating free list", (Throwable)e);
        }
        this.pageMemory = pageMemory;
    }

    private static VolatileDataRegionConfiguration regionConfiguration(VolatilePageMemoryProfileConfiguration cfg, int pageSize) {
        VolatilePageMemoryProfileView cfgView = (VolatilePageMemoryProfileView)cfg.value();
        long initSize = cfgView.initSizeBytes();
        long maxSize = cfgView.maxSizeBytes();
        if (maxSize == -1L) {
            maxSize = StorageEngine.defaultDataRegionSize();
            LOG.info("{}.{} property is not specified, setting its value to {}", cfg.name().value(), cfg.maxSizeBytes().key(), maxSize);
        }
        if (initSize == -1L) {
            initSize = maxSize;
            LOG.info("{}.{} property is not specified, setting its value to {}", cfg.name().value(), cfg.initSizeBytes().key(), maxSize);
        }
        return VolatileDataRegionConfiguration.builder().name(cfgView.name()).pageSize(pageSize).initSize(initSize).maxSize(maxSize).build();
    }

    private static FreeListImpl createFreeList(PageMemory pageMemory) throws IgniteInternalCheckedException {
        long metaPageId = pageMemory.allocatePageNoReuse(0, 0, (byte)2);
        return new FreeListImpl("VolatileFreeList", 0, 0, pageMemory, metaPageId, true, null);
    }

    public void stop() throws Exception {
        IgniteUtils.closeAllManually(this.freeList, this.pageMemory != null ? () -> this.pageMemory.stop(true) : null);
    }

    @Override
    public VolatilePageMemory pageMemory() {
        this.checkDataRegionStarted();
        return this.pageMemory;
    }

    public ReuseList reuseList() {
        return this.freeList;
    }

    public FreeListImpl freeList() {
        this.checkDataRegionStarted();
        return this.freeList;
    }

    private void checkDataRegionStarted() {
        if (this.pageMemory == null) {
            throw new StorageException("Data region not started");
        }
    }
}

