/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage.rocksdb.index;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.rocksdb.ColumnFamily;
import org.apache.ignite3.internal.rocksdb.RocksUtils;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.index.HashIndexStorage;
import org.apache.ignite3.internal.storage.index.IndexRow;
import org.apache.ignite3.internal.storage.index.StorageHashIndexDescriptor;
import org.apache.ignite3.internal.storage.rocksdb.IgniteRocksDbException;
import org.apache.ignite3.internal.storage.rocksdb.PartitionDataHelper;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbMetaStorage;
import org.apache.ignite3.internal.storage.rocksdb.RocksDbStorageUtils;
import org.apache.ignite3.internal.storage.rocksdb.index.AbstractRocksDbIndexStorage;
import org.apache.ignite3.internal.storage.rocksdb.instance.SharedRocksDbInstance;
import org.apache.ignite3.internal.storage.util.StorageState;
import org.apache.ignite3.internal.storage.util.StorageUtils;
import org.apache.ignite3.internal.util.ArrayUtils;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.util.HashUtils;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteBatchWithIndex;

public class RocksDbHashIndexStorage
extends AbstractRocksDbIndexStorage
implements HashIndexStorage {
    public static final int FIXED_PREFIX_LENGTH = 14;
    private final ColumnFamily indexCf;
    private final byte[] constantPrefix;

    public RocksDbHashIndexStorage(StorageHashIndexDescriptor descriptor, int tableId, int partitionId, ColumnFamily indexCf, RocksDbMetaStorage indexMetaStorage) {
        super(descriptor, tableId, partitionId, indexMetaStorage);
        this.indexCf = indexCf;
        this.constantPrefix = ByteBuffer.allocate(10).order(RocksDbStorageUtils.KEY_BYTE_ORDER).putInt(tableId).putInt(descriptor.id()).putShort((short)partitionId).array();
    }

    @Override
    public StorageHashIndexDescriptor indexDescriptor() {
        return (StorageHashIndexDescriptor)this.descriptor;
    }

    @Override
    public Cursor<RowId> get(BinaryTuple key) {
        return this.busyDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            this.throwExceptionIfIndexNotBuilt();
            final byte[] rangeStart = this.rocksPrefix(key);
            byte[] rangeEnd = RocksUtils.incrementPrefix(rangeStart);
            return new AbstractRocksDbIndexStorage.UpToDatePeekCursor<RowId>(rangeEnd, this.indexCf, rangeStart){

                @Override
                protected RowId map(ByteBuffer byteBuffer) {
                    long mostSignificantBits = byteBuffer.getLong(rangeStart.length);
                    long leastSignificantBits = byteBuffer.getLong(rangeStart.length + 8);
                    return new RowId(RocksDbHashIndexStorage.this.partitionId, mostSignificantBits, leastSignificantBits);
                }
            };
        });
    }

    @Override
    public void put(IndexRow row) {
        this.busyNonDataRead(() -> {
            try {
                WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
                writeBatch.put(this.indexCf.handle(), this.rocksKey(row), ArrayUtils.BYTE_EMPTY_ARRAY);
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Unable to insert data into hash index. Index ID: " + this.descriptor.id(), e);
            }
        });
    }

    @Override
    public void remove(IndexRow row) {
        this.busyNonDataRead(() -> {
            StorageUtils.throwExceptionIfStorageInProgressOfRebalance((StorageState)((Object)((Object)this.state.get())), this::createStorageInfo);
            try {
                WriteBatchWithIndex writeBatch = PartitionDataHelper.requireWriteBatch();
                writeBatch.delete(this.indexCf.handle(), this.rocksKey(row));
                return null;
            }
            catch (RocksDBException e) {
                throw new IgniteRocksDbException("Unable to remove data from hash index. Index ID: " + this.descriptor.id(), e);
            }
        });
    }

    private byte[] rocksPrefix(BinaryTuple prefix) {
        return this.rocksPrefix(prefix, 0).array();
    }

    private ByteBuffer rocksPrefix(BinaryTuple prefix, int extraLength) {
        ByteBuffer keyBytes = prefix.byteBuffer();
        return ByteBuffer.allocate(14 + keyBytes.remaining() + extraLength).order(RocksDbStorageUtils.KEY_BYTE_ORDER).put(this.constantPrefix).putInt(HashUtils.hash32(keyBytes)).put(keyBytes);
    }

    private byte[] rocksKey(IndexRow row) {
        RowId rowId = row.rowId();
        return this.rocksPrefix(row.indexColumns(), 16).putLong(rowId.mostSignificantBits()).putLong(rowId.leastSignificantBits()).array();
    }

    @Override
    public void clearIndex(WriteBatch writeBatch) throws RocksDBException {
        SharedRocksDbInstance.deleteByPrefix(writeBatch, this.indexCf, this.constantPrefix);
    }
}

