/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed.raft.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.partition.replicator.network.command.BuildIndexCommand;
import org.apache.ignite3.internal.partition.replicator.raft.CommandResult;
import org.apache.ignite3.internal.partition.replicator.raft.handlers.AbstractCommandHandler;
import org.apache.ignite3.internal.partition.replicator.raft.snapshot.PartitionDataStorage;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowUpgrader;
import org.apache.ignite3.internal.schema.SchemaDescriptor;
import org.apache.ignite3.internal.schema.SchemaRegistry;
import org.apache.ignite3.internal.storage.BinaryRowAndRowId;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.table.distributed.StorageUpdateHandler;
import org.apache.ignite3.internal.table.distributed.index.IndexMeta;
import org.apache.ignite3.internal.table.distributed.index.IndexMetaStorage;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatus;
import org.apache.ignite3.internal.table.distributed.index.MetaIndexStatusChange;
import org.apache.ignite3.internal.table.distributed.raft.handlers.BuildIndexRowVersionChooser;
import org.apache.ignite3.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;

public class BuildIndexCommandHandler
extends AbstractCommandHandler<BuildIndexCommand> {
    private static final IgniteLogger LOG = Loggers.forClass(BuildIndexCommandHandler.class);
    private final PartitionDataStorage storage;
    private final IndexMetaStorage indexMetaStorage;
    private final StorageUpdateHandler storageUpdateHandler;
    private final SchemaRegistry schemaRegistry;

    public BuildIndexCommandHandler(PartitionDataStorage storage, IndexMetaStorage indexMetaStorage, StorageUpdateHandler storageUpdateHandler, SchemaRegistry schemaRegistry) {
        this.storage = storage;
        this.indexMetaStorage = indexMetaStorage;
        this.storageUpdateHandler = storageUpdateHandler;
        this.schemaRegistry = schemaRegistry;
    }

    @Override
    protected CommandResult handleInternally(BuildIndexCommand command, long commandIndex, long commandTerm, @Nullable HybridTimestamp safeTimestamp) throws IgniteInternalException {
        if (commandIndex <= this.storage.lastAppliedIndex()) {
            return CommandResult.EMPTY_NOT_APPLIED_RESULT;
        }
        IndexMeta indexMeta = this.indexMetaStorage.indexMeta(command.indexId());
        if (indexMeta == null || indexMeta.isDropped()) {
            return CommandResult.EMPTY_APPLIED_RESULT;
        }
        BuildIndexRowVersionChooser rowVersionChooser = this.createBuildIndexRowVersionChooser(indexMeta);
        BinaryRowUpgrader binaryRowUpgrader = this.createBinaryRowUpgrader(indexMeta);
        this.storage.runConsistently(locker -> {
            ArrayList<UUID> rowUuids = new ArrayList<UUID>(command.rowIds());
            Collections.sort(rowUuids);
            Stream<BinaryRowAndRowId> buildIndexRowStream = this.createBuildIndexRowStream(rowUuids, locker, rowVersionChooser, binaryRowUpgrader);
            RowId nextRowIdToBuild = command.finish() ? null : this.toRowId(Objects.requireNonNull(CollectionUtils.last(rowUuids))).increment();
            this.storageUpdateHandler.getIndexUpdateHandler().buildIndex(command.indexId(), buildIndexRowStream, nextRowIdToBuild);
            this.storage.lastApplied(commandIndex, commandTerm);
            return null;
        });
        if (command.finish()) {
            LOG.info("Finish building the index [tableId={}, partitionId={}, indexId={}].", this.storage.tableId(), this.storage.partitionId(), command.indexId());
        }
        return CommandResult.EMPTY_APPLIED_RESULT;
    }

    private BuildIndexRowVersionChooser createBuildIndexRowVersionChooser(IndexMeta indexMeta) {
        MetaIndexStatusChange registeredChangeInfo = indexMeta.statusChange(MetaIndexStatus.REGISTERED);
        MetaIndexStatusChange buildingChangeInfo = indexMeta.statusChange(MetaIndexStatus.BUILDING);
        return new BuildIndexRowVersionChooser(this.storage, registeredChangeInfo.activationTimestamp(), buildingChangeInfo.activationTimestamp());
    }

    private BinaryRowUpgrader createBinaryRowUpgrader(IndexMeta indexMeta) {
        SchemaDescriptor schema = this.schemaRegistry.schema(indexMeta.tableVersion());
        return new BinaryRowUpgrader(this.schemaRegistry, schema);
    }

    private Stream<BinaryRowAndRowId> createBuildIndexRowStream(List<UUID> rowUuids, MvPartitionStorage.Locker locker, BuildIndexRowVersionChooser rowVersionChooser, BinaryRowUpgrader binaryRowUpgrader) {
        return rowUuids.stream().map(this::toRowId).peek(locker::lock).map(rowVersionChooser::chooseForBuildIndex).flatMap(Collection::stream).map(binaryRowAndRowId -> BuildIndexCommandHandler.upgradeBinaryRow(binaryRowUpgrader, binaryRowAndRowId));
    }

    private static BinaryRowAndRowId upgradeBinaryRow(BinaryRowUpgrader upgrader, BinaryRowAndRowId source) {
        BinaryRow sourceBinaryRow = source.binaryRow();
        BinaryRow upgradedBinaryRow = upgrader.upgrade(sourceBinaryRow);
        return upgradedBinaryRow == sourceBinaryRow ? source : new BinaryRowAndRowId(upgradedBinaryRow, source.rowId());
    }

    private RowId toRowId(UUID rowUuid) {
        return new RowId(this.storageUpdateHandler.partitionId(), rowUuid);
    }
}

