/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tx.TransactionIds;
import org.apache.ignite3.internal.tx.TxPriority;
import org.apache.ignite3.internal.tx.impl.NodeIdSupplier;

public class TransactionIdGenerator {
    private final NodeIdSupplier nodeIdSupplier;

    public TransactionIdGenerator(NodeIdSupplier nodeIdSupplier) {
        this.nodeIdSupplier = nodeIdSupplier;
    }

    public TransactionIdGenerator(int nodeId) {
        this(() -> nodeId);
    }

    public UUID transactionIdFor(HybridTimestamp beginTimestamp) {
        return this.transactionIdFor(beginTimestamp, TxPriority.NORMAL);
    }

    public UUID transactionIdFor(HybridTimestamp beginTimestamp, TxPriority priority) {
        return TransactionIds.transactionId(beginTimestamp, this.nodeIdSupplier.nodeId(), priority);
    }
}

