/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.util.subscription;

import java.util.concurrent.Flow;
import java.util.function.Function;

public final class TransformingPublisher<T, R>
implements Flow.Publisher<R> {
    private final Flow.Publisher<T> publisher;
    private final Function<T, R> function;

    public TransformingPublisher(Flow.Publisher<T> publisher, Function<T, R> function) {
        this.publisher = publisher;
        this.function = function;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        this.publisher.subscribe(new SubscriberImpl(subscriber));
    }

    private class SubscriberImpl
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super R> subscriber;

        SubscriberImpl(Flow.Subscriber<? super R> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscriber.onSubscribe(subscription);
        }

        @Override
        public void onNext(T item) {
            this.subscriber.onNext(TransformingPublisher.this.function.apply(item));
        }

        @Override
        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

