/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util.concurrent;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.util.Mpsc;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.concurrent.RejectedExecutionHandler;
import org.apache.ignite3.raft.jraft.util.concurrent.RejectedExecutionHandlers;
import org.apache.ignite3.raft.jraft.util.concurrent.SingleThreadExecutor;

public class MpscSingleThreadExecutor
implements SingleThreadExecutor {
    private static final IgniteLogger LOG = Loggers.forClass(MpscSingleThreadExecutor.class);
    private static final AtomicIntegerFieldUpdater<MpscSingleThreadExecutor> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(MpscSingleThreadExecutor.class, "state");
    private static final long DEFAULT_SHUTDOWN_TIMEOUT = 15L;
    private static final int ST_NOT_STARTED = 1;
    private static final int ST_STARTED = 2;
    private static final int ST_SHUTDOWN = 3;
    private static final int ST_TERMINATED = 4;
    private static final Runnable WAKEUP_TASK = () -> {};
    private final Queue<Runnable> taskQueue;
    private final Executor executor;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private final Semaphore threadLock = new Semaphore(0);
    private volatile int state = 1;
    private volatile Worker worker;
    private static final AtomicIntegerFieldUpdater<Worker> NOTIFY_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Worker.class, "notifyNeeded");
    private static final int NOT_NEEDED = 0;
    private static final int NEEDED = 1;

    public MpscSingleThreadExecutor(int maxPendingTasks, ThreadFactory threadFactory) {
        this(maxPendingTasks, threadFactory, RejectedExecutionHandlers.reject());
    }

    public MpscSingleThreadExecutor(int maxPendingTasks, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        this.taskQueue = this.newTaskQueue(maxPendingTasks);
        this.executor = new ThreadPerTaskExecutor(threadFactory);
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    @Override
    public boolean shutdownGracefully() {
        return this.shutdownGracefully(15L, TimeUnit.SECONDS);
    }

    @Override
    public boolean shutdownGracefully(long timeout, TimeUnit unit) {
        boolean wakeup;
        int newState;
        int oldState;
        Requires.requireNonNull(unit, "unit");
        if (this.isShutdown()) {
            return this.awaitTermination(timeout, unit);
        }
        do {
            if (this.isShutdown()) {
                return this.awaitTermination(timeout, unit);
            }
            wakeup = true;
            oldState = this.state;
            switch (oldState) {
                case 1: 
                case 2: {
                    newState = 3;
                    break;
                }
                default: {
                    newState = oldState;
                    wakeup = false;
                }
            }
        } while (!STATE_UPDATER.compareAndSet(this, oldState, newState));
        if (oldState == 1) {
            try {
                this.doStartWorker();
            }
            catch (Throwable t) {
                this.state = 4;
                if (!(t instanceof Exception)) {
                    throw new RuntimeException(t);
                }
                return true;
            }
        }
        if (wakeup) {
            this.wakeupAndStopWorker();
        }
        return this.awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable task) {
        Requires.requireNonNull(task, "task");
        this.addTask(task);
        this.startWorker();
        this.wakeupForTask();
    }

    public void addShutdownHook(Runnable task) {
        this.execute(() -> this.shutdownHooks.add(task));
    }

    public void removeShutdownHook(Runnable task) {
        this.execute(() -> this.shutdownHooks.remove(task));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runShutdownHooks() {
        boolean ran = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> copy = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable task : copy) {
                try {
                    task.run();
                }
                catch (Throwable t) {
                    LOG.warn("Shutdown hook raised an exception.", t);
                }
                finally {
                    ran = true;
                }
            }
        }
        return ran;
    }

    public boolean isShutdown() {
        return this.state >= 3;
    }

    public boolean isTerminated() {
        return this.state == 4;
    }

    public boolean inWorkerThread(Thread thread) {
        Worker worker = this.worker;
        return worker != null && worker.thread == thread;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        Requires.requireNonNull(unit, "unit");
        try {
            if (this.threadLock.tryAcquire(timeout, unit)) {
                this.threadLock.release();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.isTerminated();
    }

    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return maxPendingTasks == Integer.MAX_VALUE ? Mpsc.newMpscQueue() : Mpsc.newMpscQueue(maxPendingTasks);
    }

    protected void addTask(Runnable task) {
        if (!this.offerTask(task)) {
            this.reject(task);
        }
    }

    protected final boolean offerTask(Runnable task) {
        if (this.isShutdown()) {
            MpscSingleThreadExecutor.reject();
        }
        return this.taskQueue.offer(task);
    }

    private void wakeupForTask() {
        Worker worker = this.worker;
        if (worker != null) {
            worker.notifyIfNeeded();
        }
    }

    private void wakeupAndStopWorker() {
        this.taskQueue.offer(WAKEUP_TASK);
        Worker worker = this.worker;
        if (worker != null) {
            worker.notifyAndStop();
        }
    }

    private void startWorker() {
        if (this.state != 1) {
            return;
        }
        if (STATE_UPDATER.compareAndSet(this, 1, 2)) {
            try {
                this.doStartWorker();
            }
            catch (Throwable t) {
                this.state = 1;
                throw new RuntimeException("Fail to start executor", t);
            }
        }
    }

    private void doStartWorker() {
        this.executor.execute(() -> {
            this.worker = new Worker(Thread.currentThread());
            try {
                this.worker.run();
            }
            catch (Throwable t) {
                LOG.warn("Unexpected exception from executor: ", t);
            }
            finally {
                int oldState;
                while ((oldState = this.state) < 3 && !STATE_UPDATER.compareAndSet(this, oldState, 3)) {
                }
                this.runShutdownHooks();
                this.state = 4;
                this.threadLock.release();
            }
        });
    }

    protected final void reject(Runnable task) {
        this.rejectedExecutionHandler.rejected(task, this);
    }

    protected static void reject() {
        throw new RejectedExecutionException("Executor terminated");
    }

    private static class ThreadPerTaskExecutor
    implements Executor {
        private final ThreadFactory threadFactory;

        ThreadPerTaskExecutor(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public void execute(Runnable task) {
            this.threadFactory.newThread(task).start();
        }
    }

    private class Worker
    implements Runnable {
        final Thread thread;
        volatile int notifyNeeded = 0;
        boolean stop = false;

        private Worker(Thread thread) {
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Runnable task;
                if ((task = this.pollTask()) == null) {
                    Worker worker = this;
                    synchronized (worker) {
                        block8: {
                            if (this.stop) {
                                break;
                            }
                            this.notifyNeeded = 1;
                            try {
                                this.wait(1000L, 10);
                                if (!this.stop && !MpscSingleThreadExecutor.this.isShutdown()) break block8;
                                break;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
                this.runTask(task);
                if (MpscSingleThreadExecutor.this.isShutdown()) break;
            }
            this.runAllTasks();
        }

        private Runnable pollTask() {
            return MpscSingleThreadExecutor.this.taskQueue.poll();
        }

        private void runTask(Runnable task) {
            try {
                task.run();
            }
            catch (Throwable t) {
                LOG.warn("Caught an unknown error while executing a task", t);
            }
        }

        private void runAllTasks() {
            Runnable task;
            while ((task = this.pollTask()) != null) {
                this.runTask(task);
            }
        }

        private boolean isShuttingDown() {
            return MpscSingleThreadExecutor.this.state != 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfNeeded() {
            if (this.notifyNeeded == 0) {
                return;
            }
            if (NOTIFY_UPDATER.getAndSet(this, 0) == 1) {
                Worker worker = this;
                synchronized (worker) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAndStop() {
            Worker worker = this;
            synchronized (worker) {
                this.stop = true;
                this.notifyAll();
            }
        }
    }
}

