/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSenderDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(SyncSenderDescriptor.class);
    private SyncSenderConfig conf = new SyncSenderConfig();

    private SyncSenderDescriptor() {
        this.loadProps();
    }

    public static SyncSenderDescriptor getInstance() {
        return SyncSenderDescriptorHolder.INSTANCE;
    }

    public SyncSenderConfig getConfig() {
        return this.conf;
    }

    public void setConfig(SyncSenderConfig conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProps() {
        FileInputStream inputStream;
        String url = System.getProperty("IOTDB_CONF", null);
        if (url == null) {
            url = System.getProperty("IOTDB_HOME", null);
            if (url == null) {
                logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-sync-client.properties");
                return;
            }
            url = url + File.separatorChar + "conf" + File.separatorChar + "iotdb-sync-client.properties";
        } else {
            url = url + File.separatorChar + "iotdb-sync-client.properties";
        }
        try {
            inputStream = new FileInputStream(new File(url));
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find sync config file {}", (Object)url, (Object)e);
            return;
        }
        logger.info("Start to read sync config file {}", (Object)url);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.conf.setServerIp(properties.getProperty("server_ip", this.conf.getServerIp()));
            this.conf.setServerPort(Integer.parseInt(properties.getProperty("server_port", Integer.toString(this.conf.getServerPort()))));
            this.conf.setSyncPeriodInSecond(Integer.parseInt(properties.getProperty("sync_period_in_second", Integer.toString(this.conf.getSyncPeriodInSecond()))));
            String storageGroups = properties.getProperty("sync_storage_groups", null);
            if (storageGroups != null) {
                String[] splits = storageGroups.split(",");
                ArrayList<String> storageGroupList = new ArrayList<String>();
                Arrays.stream(splits).forEach(sg -> storageGroupList.add(sg.trim()));
                this.conf.setStorageGroupList(storageGroupList);
            }
            this.conf.setMaxNumOfSyncFileRetry(Integer.parseInt(properties.getProperty("max_number_of_sync_file_retry", Integer.toString(this.conf.getMaxNumOfSyncFileRetry()))));
            return;
        }
        catch (IOException e) {
            logger.warn("Cannot load sync config file, use default sync configuration.", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.warn("Error format in sync config file, use default sync configuration.", (Throwable)e);
            return;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("Fail to close sync config file input stream.", (Throwable)e);
            }
        }
    }

    private static class SyncSenderDescriptorHolder {
        private static final SyncSenderDescriptor INSTANCE = new SyncSenderDescriptor();

        private SyncSenderDescriptorHolder() {
        }
    }
}

