/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import java.util.Collections;
import org.apache.iotdb.cluster.metadata.MetaPuller;
import org.apache.iotdb.db.exception.IoTDBException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterQueryUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClusterQueryUtils.class);

    private ClusterQueryUtils() {
    }

    public static void checkPathExistence(PartialPath path) throws QueryProcessException {
        if (!IoTDB.metaManager.isPathExist(path)) {
            try {
                MetaPuller.getInstance().pullTimeSeriesSchemas(Collections.singletonList(path), null);
            }
            catch (MetadataException e) {
                throw new QueryProcessException((IoTDBException)e);
            }
        }
    }

    public static String getPathStrListForRequest(Path path) {
        return path.getFullPath();
    }

    public static MeasurementPath getAssembledPathFromRequest(String pathString, byte dataType) {
        try {
            MeasurementPath matchedPath = new MeasurementPath(pathString);
            matchedPath.setMeasurementSchema((IMeasurementSchema)new MeasurementSchema(matchedPath.getMeasurement(), TSDataType.deserialize((byte)dataType)));
            return matchedPath;
        }
        catch (IllegalPathException e) {
            logger.error("Failed to create partial path, fullPath is {}.", (Object)pathString, (Object)e);
            return null;
        }
    }
}

