/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar.wrapped;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import me.tongfei.progressbar.ProgressBar;

public class ProgressBarWrappedInputStream
extends FilterInputStream {
    private ProgressBar pb;
    private long mark = 0L;

    public ProgressBarWrappedInputStream(InputStream in, ProgressBar pb) {
        super(in);
        this.pb = pb;
    }

    public ProgressBar getProgressBar() {
        return this.pb;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r != -1) {
            this.pb.step();
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r != -1) {
            this.pb.stepBy(r);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r != -1) {
            this.pb.stepBy(r);
        }
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.in.skip(n);
        this.pb.stepBy(r);
        return r;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.pb.getCurrent();
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.pb.stepTo(this.mark);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.pb.close();
    }
}

