/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.net.ConnectException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.cluster.rpc.thrift.HeartBeatResponse;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.server.member.RaftMember;
import org.apache.iotdb.cluster.server.monitor.Peer;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatHandler
implements AsyncMethodCallback<HeartBeatResponse> {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatHandler.class);
    private RaftMember localMember;
    private String memberName;
    private Node receiver;

    public HeartbeatHandler(RaftMember localMember, Node receiver) {
        this.localMember = localMember;
        this.receiver = receiver;
        this.memberName = localMember.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(HeartBeatResponse resp) {
        long followerTerm = resp.getTerm();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received a heartbeat response {} for last log index {}", new Object[]{this.memberName, followerTerm, resp.getLastLogIndex()});
        }
        if (followerTerm == -1L) {
            this.handleNormalHeartbeatResponse(resp);
        } else {
            AtomicLong atomicLong = this.localMember.getTerm();
            synchronized (atomicLong) {
                long currTerm = this.localMember.getTerm().get();
                if (currTerm < followerTerm) {
                    logger.info("{}: Losing leadership because current term {} is smaller than {}", new Object[]{this.memberName, currTerm, followerTerm});
                    this.localMember.stepDown(followerTerm, false);
                }
            }
        }
    }

    private void handleNormalHeartbeatResponse(HeartBeatResponse resp) {
        this.localMember.processValidHeartbeatResp(resp, this.receiver);
        Node follower = resp.getFollower();
        long lastLogIdx = resp.getLastLogIndex();
        long lastLogTerm = resp.getLastLogTerm();
        long localLastLogIdx = this.localMember.getLogManager().getLastLogIndex();
        long localLastLogTerm = this.localMember.getLogManager().getLastLogTerm();
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Node {} is still alive, log index: {}/{}, log term: {}/{}", new Object[]{this.memberName, follower, lastLogIdx, localLastLogIdx, lastLogTerm, localLastLogTerm});
        }
        Peer peer = this.localMember.getPeerMap().computeIfAbsent(follower, k -> new Peer(this.localMember.getLogManager().getLastLogIndex()));
        if (!this.localMember.getLogManager().isLogUpToDate(lastLogTerm, lastLogIdx) || !this.localMember.getLogManager().matchTerm(lastLogTerm, lastLogIdx)) {
            if (lastLogIdx == -1L) {
                peer.setMatchIndex(-1L);
            }
            if (lastLogIdx == peer.getLastHeartBeatIndex() && !resp.isInstallingSnapshot()) {
                int inconsistentNum = peer.incInconsistentHeartbeatNum();
                if (inconsistentNum >= 5) {
                    logger.info("{}: catching up node {}, index-term: {}-{}/{}-{}, peer match index {}", new Object[]{this.memberName, follower, lastLogIdx, lastLogTerm, localLastLogIdx, localLastLogTerm, peer.getMatchIndex()});
                    this.localMember.catchUp(follower, lastLogIdx);
                }
            } else {
                peer.resetInconsistentHeartbeatNum();
            }
        } else {
            peer.setMatchIndex(Math.max(peer.getMatchIndex(), lastLogIdx));
            peer.resetInconsistentHeartbeatNum();
        }
        peer.setLastHeartBeatIndex(lastLogIdx);
    }

    public void onError(Exception exception) {
        if (exception instanceof ConnectException) {
            logger.warn("{}: Cannot connect to {}: {}", new Object[]{this.memberName, this.receiver, exception.getMessage()});
        } else {
            logger.error("{}: Heart beat error, receiver {}, {}", new Object[]{this.memberName, this.receiver, exception.getMessage()});
        }
    }
}

