/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.v2.file.header;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.MetaMarker;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.reader.TsFileInput;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ChunkHeaderV2 {
    private ChunkHeaderV2() {
    }

    public static ChunkHeader deserializeFrom(InputStream inputStream, boolean markerRead) throws IOException {
        byte marker;
        if (!markerRead && (marker = (byte)inputStream.read()) != 1) {
            MetaMarker.handleUnexpectedMarker(marker);
        }
        String measurementID = ReadWriteIOUtils.readString(inputStream);
        int dataSize = ReadWriteIOUtils.readInt(inputStream);
        TSDataType dataType = TSDataType.deserialize((byte)ReadWriteIOUtils.readShort(inputStream));
        int numOfPages = ReadWriteIOUtils.readInt(inputStream);
        CompressionType type = CompressionType.deserialize((byte)ReadWriteIOUtils.readShort(inputStream));
        TSEncoding encoding = TSEncoding.deserialize((byte)ReadWriteIOUtils.readShort(inputStream));
        return new ChunkHeader(measurementID, dataSize, dataType, type, encoding, numOfPages);
    }

    public static ChunkHeader deserializeFrom(TsFileInput input, long offset, int chunkHeaderSize, boolean markerRead) throws IOException {
        long offsetVar = offset;
        if (!markerRead) {
            ++offsetVar;
        }
        ByteBuffer buffer = ByteBuffer.allocate(chunkHeaderSize);
        input.read(buffer, offsetVar);
        buffer.flip();
        int size = buffer.getInt();
        String measurementID = ReadWriteIOUtils.readStringWithLength(buffer, size);
        int dataSize = ReadWriteIOUtils.readInt(buffer);
        TSDataType dataType = TSDataType.deserialize((byte)ReadWriteIOUtils.readShort(buffer));
        ReadWriteIOUtils.readInt(buffer);
        CompressionType type = CompressionType.deserialize((byte)ReadWriteIOUtils.readShort(buffer));
        TSEncoding encoding = TSEncoding.deserialize((byte)ReadWriteIOUtils.readShort(buffer));
        return new ChunkHeader(1, measurementID, dataSize, chunkHeaderSize, dataType, type, encoding);
    }

    public static int getSerializedSize(String measurementID) {
        return 5 + measurementID.getBytes(TSFileConfig.STRING_CHARSET).length + 4 + 2 + 2 + 2 + 4;
    }
}

