/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeUtils {
    private static final Logger logger = LoggerFactory.getLogger(MergeUtils.class);

    private MergeUtils() {
    }

    private static List<Path> collectFileSeries(TsFileSequenceReader sequenceReader) throws IOException {
        return sequenceReader.getAllPaths();
    }

    public static long[] findTotalAndLargestSeriesChunkNum(TsFileResource tsFileResource, TsFileSequenceReader sequenceReader) throws IOException {
        long totalChunkNum = 0L;
        long maxChunkNum = Long.MIN_VALUE;
        List<Path> paths = MergeUtils.collectFileSeries(sequenceReader);
        for (Path path : paths) {
            List chunkMetadataList = sequenceReader.getChunkMetadataList(path, true);
            totalChunkNum += (long)chunkMetadataList.size();
            maxChunkNum = (long)chunkMetadataList.size() > maxChunkNum ? (long)chunkMetadataList.size() : maxChunkNum;
        }
        logger.debug("In file {}, total chunk num {}, series max chunk num {}", new Object[]{tsFileResource, totalChunkNum, maxChunkNum});
        return new long[]{totalChunkNum, maxChunkNum};
    }

    public static long getFileMetaSize(TsFileResource seqFile, TsFileSequenceReader sequenceReader) {
        return seqFile.getTsFileSize() - sequenceReader.getFileMetadataPos();
    }
}

