/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.window.ainode;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.BottomInferenceWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.CountInferenceWindowParameter;
import org.apache.iotdb.db.queryengine.execution.operator.window.ainode.InferenceWindowType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class InferenceWindowParameter {
    protected InferenceWindowType windowType;

    public InferenceWindowType getWindowType() {
        return this.windowType;
    }

    public abstract void serializeAttributes(ByteBuffer var1);

    public abstract void serializeAttributes(DataOutputStream var1) throws IOException;

    public void serialize(ByteBuffer buffer) {
        ReadWriteIOUtils.write((int)this.windowType.ordinal(), (ByteBuffer)buffer);
        this.serializeAttributes(buffer);
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.windowType.ordinal(), (OutputStream)stream);
        this.serializeAttributes(stream);
    }

    public static InferenceWindowParameter deserialize(ByteBuffer byteBuffer) {
        InferenceWindowType windowType = InferenceWindowType.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
        if (windowType == InferenceWindowType.TAIL) {
            return BottomInferenceWindowParameter.deserialize(byteBuffer);
        }
        if (windowType == InferenceWindowType.COUNT) {
            return CountInferenceWindowParameter.deserialize(byteBuffer);
        }
        throw new SemanticException("Unsupported inference window type: " + (Object)((Object)windowType));
    }
}

