/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.unary.scalar;

import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.unary.UnaryColumnTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.BytesUtils;

public class SubStringColumnTransformer
extends UnaryColumnTransformer {
    private final int beginPosition;
    private final int endPosition;
    public static final String EMPTY_STRING = "";

    public SubStringColumnTransformer(Type returnType, ColumnTransformer childColumnTransformer, int beginPosition, int length) {
        super(returnType, childColumnTransformer);
        if (length < 0) {
            throw new SemanticException("Argument exception,the scalar function substring length must not be less than 0");
        }
        this.endPosition = length == Integer.MAX_VALUE || beginPosition > Integer.MAX_VALUE - length ? Integer.MAX_VALUE : beginPosition + length - 1;
        this.beginPosition = beginPosition;
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (!column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column column, ColumnBuilder columnBuilder, boolean[] selection) {
        int n = column.getPositionCount();
        for (int i = 0; i < n; ++i) {
            if (selection[i] && !column.isNull(i)) {
                this.transform(column, columnBuilder, i);
                continue;
            }
            columnBuilder.appendNull();
        }
    }

    private void transform(Column column, ColumnBuilder columnBuilder, int i) {
        int minMax;
        String currentValue = column.getBinary(i).getStringValue(TSFileConfig.STRING_CHARSET);
        if (this.beginPosition > currentValue.length()) {
            throw new SemanticException("Argument exception,the scalar function substring beginPosition must not be greater than the string length");
        }
        int maxMin = Math.max(1, this.beginPosition);
        currentValue = maxMin > (minMax = Math.min(currentValue.length(), this.endPosition)) ? EMPTY_STRING : currentValue.substring(maxMin - 1, minMax);
        columnBuilder.writeBinary(BytesUtils.valueOf((String)currentValue));
    }
}

