/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.scalar;

import org.apache.iotdb.db.queryengine.transformation.api.LayerReader;
import org.apache.iotdb.db.queryengine.transformation.dag.transformer.unary.UnaryTransformer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class SubStringFunctionTransformer
extends UnaryTransformer {
    private int beginPosition;
    private int endPosition;

    public SubStringFunctionTransformer(LayerReader layerReader, int beginPosition, int length) {
        super(layerReader);
        this.endPosition = length == Integer.MAX_VALUE ? Integer.MAX_VALUE : beginPosition + length - 1;
        int n = this.beginPosition = beginPosition > 0 ? beginPosition - 1 : 0;
        if (this.layerReaderDataType != TSDataType.TEXT && this.layerReaderDataType != TSDataType.STRING) {
            throw new UnSupportedDataTypeException("Unsupported data type: " + this.layerReaderDataType);
        }
    }

    @Override
    public TSDataType[] getDataTypes() {
        return new TSDataType[]{TSDataType.TEXT};
    }

    @Override
    public void transform(Column[] columns, ColumnBuilder builder) {
        int count = columns[0].getPositionCount();
        Binary[] binaries = columns[0].getBinaries();
        boolean[] isNulls = columns[0].isNull();
        for (int i = 0; i < count; ++i) {
            if (!isNulls[i]) {
                String value = binaries[i].getStringValue(TSFileConfig.STRING_CHARSET);
                Binary result = BytesUtils.valueOf((String)this.substring(value));
                builder.writeBinary(result);
                continue;
            }
            builder.appendNull();
        }
    }

    private String substring(String str) {
        if (this.beginPosition >= str.length() || this.endPosition < 0) {
            return "";
        }
        if (this.endPosition >= str.length()) {
            return str.substring(this.beginPosition);
        }
        return str.substring(this.beginPosition, this.endPosition);
    }
}

