/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.broker;

import io.moquette.broker.config.IConfig;
import java.util.Locale;
import java.util.Optional;

class BrokerConfiguration {
    private final boolean allowAnonymous;
    private final boolean peerCertificateAsUsername;
    private final boolean allowZeroByteClientId;
    private final boolean reauthorizeSubscriptionsOnConnect;
    private final int bufferFlushMillis;
    private final int topicAliasMaximum;
    private int receiveMaximum;
    private Optional<Integer> serverKeepAlive = Optional.empty();

    BrokerConfiguration(IConfig props) {
        this.allowAnonymous = props.boolProp("allow_anonymous", true);
        this.peerCertificateAsUsername = props.boolProp("peer_certificate_as_username", false);
        this.allowZeroByteClientId = props.boolProp("allow_zero_byte_client_id", false);
        this.reauthorizeSubscriptionsOnConnect = props.boolProp("reauthorize_subscriptions_on_connect", false);
        String bufferFlushMillisProp = props.getProperty("buffer_flush_millis");
        if (bufferFlushMillisProp != null && !bufferFlushMillisProp.isEmpty()) {
            switch (bufferFlushMillisProp.toLowerCase(Locale.ROOT)) {
                case "immediate": {
                    this.bufferFlushMillis = 0;
                    break;
                }
                case "full": {
                    this.bufferFlushMillis = -1;
                    break;
                }
                default: {
                    String errorMsg = String.format("Can't state value of %s property. Has to be 'immediate', 'full' or a number >= -1, found %s", "buffer_flush_millis", bufferFlushMillisProp);
                    try {
                        this.bufferFlushMillis = Integer.parseInt(bufferFlushMillisProp);
                        if (this.bufferFlushMillis < -1) {
                            throw new IllegalArgumentException(errorMsg);
                        }
                        break;
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException(errorMsg);
                    }
                }
            }
        } else {
            this.bufferFlushMillis = props.boolProp("immediate_buffer_flush", true) ? 0 : -1;
        }
        this.receiveMaximum = props.intProp("receive_maximum", 66560);
        this.topicAliasMaximum = props.intProp("topic_alias_maximum", 0);
        if (props.getProperty("server_keep_alive") != null) {
            this.serverKeepAlive = Optional.of((int)props.durationProp("server_keep_alive").toMillis() / 1000);
        }
    }

    public BrokerConfiguration(boolean allowAnonymous, boolean allowZeroByteClientId, boolean reauthorizeSubscriptionsOnConnect, int bufferFlushMillis) {
        this(allowAnonymous, false, allowZeroByteClientId, reauthorizeSubscriptionsOnConnect, bufferFlushMillis);
    }

    public BrokerConfiguration(boolean allowAnonymous, boolean peerCertificateAsUsername, boolean allowZeroByteClientId, boolean reauthorizeSubscriptionsOnConnect, int bufferFlushMillis) {
        this(allowAnonymous, peerCertificateAsUsername, allowZeroByteClientId, reauthorizeSubscriptionsOnConnect, bufferFlushMillis, 10);
    }

    public BrokerConfiguration(boolean allowAnonymous, boolean peerCertificateAsUsername, boolean allowZeroByteClientId, boolean reauthorizeSubscriptionsOnConnect, int bufferFlushMillis, int receiveMaximum) {
        this(allowAnonymous, peerCertificateAsUsername, allowZeroByteClientId, reauthorizeSubscriptionsOnConnect, bufferFlushMillis, receiveMaximum, 0);
    }

    public BrokerConfiguration(boolean allowAnonymous, boolean peerCertificateAsUsername, boolean allowZeroByteClientId, boolean reauthorizeSubscriptionsOnConnect, int bufferFlushMillis, int receiveMaximum, int topicAliasMaximum) {
        this.allowAnonymous = allowAnonymous;
        this.peerCertificateAsUsername = peerCertificateAsUsername;
        this.allowZeroByteClientId = allowZeroByteClientId;
        this.reauthorizeSubscriptionsOnConnect = reauthorizeSubscriptionsOnConnect;
        this.bufferFlushMillis = bufferFlushMillis;
        this.receiveMaximum = receiveMaximum;
        this.topicAliasMaximum = topicAliasMaximum;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public boolean isPeerCertificateAsUsername() {
        return this.peerCertificateAsUsername;
    }

    public boolean isAllowZeroByteClientId() {
        return this.allowZeroByteClientId;
    }

    public boolean isReauthorizeSubscriptionsOnConnect() {
        return this.reauthorizeSubscriptionsOnConnect;
    }

    public int getBufferFlushMillis() {
        return this.bufferFlushMillis;
    }

    public int receiveMaximum() {
        return this.receiveMaximum;
    }

    public int topicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public Optional<Integer> getServerKeepAlive() {
        return this.serverKeepAlive;
    }
}

