/*
 * Decompiled with CFR 0.152.
 */
package io.moquette.persistence;

import io.moquette.broker.ISessionsRepository;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;

public class MemorySessionsRepository
implements ISessionsRepository {
    private final ConcurrentMap<String, ISessionsRepository.SessionData> sessions = new ConcurrentHashMap<String, ISessionsRepository.SessionData>();
    private final ConcurrentMap<String, ISessionsRepository.Will> wills = new ConcurrentHashMap<String, ISessionsRepository.Will>();

    @Override
    public Collection<ISessionsRepository.SessionData> list() {
        return this.sessions.values();
    }

    @Override
    public void saveSession(ISessionsRepository.SessionData session) {
        this.sessions.put(session.clientId(), session);
    }

    @Override
    public void delete(ISessionsRepository.SessionData session) {
        this.sessions.remove(session.clientId());
    }

    @Override
    public void listSessionsWill(BiConsumer<String, ISessionsRepository.Will> visitor) {
        this.wills.entrySet().stream().forEach(e -> visitor.accept((String)e.getKey(), (ISessionsRepository.Will)e.getValue()));
    }

    @Override
    public void saveWill(String clientId, ISessionsRepository.Will will) {
        this.wills.put(clientId, will);
    }

    @Override
    public void deleteWill(String clientId) {
        this.wills.remove(clientId);
    }
}

