/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.server.namespaces.loader;

import org.eclipse.milo.opcua.sdk.server.api.NodeManager;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.DataTypeNodeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.MethodNodeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.ObjectNodeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.ObjectTypeNodeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.ReferenceTypeNodeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.VariableNodeLoader;
import org.eclipse.milo.opcua.sdk.server.namespaces.loader.VariableTypeNodeLoader;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNodeContext;

public class NodeLoader {
    private final UaNodeContext context;
    private final NodeManager<UaNode> nodeManager;

    public NodeLoader(UaNodeContext context, NodeManager<UaNode> nodeManager) {
        this.context = context;
        this.nodeManager = nodeManager;
    }

    public void loadNodes() throws Exception {
        new DataTypeNodeLoader(this.context, this.nodeManager).loadAllNodes();
        new MethodNodeLoader(this.context, this.nodeManager).loadAllNodes();
        new ObjectNodeLoader(this.context, this.nodeManager).loadAllNodes();
        new ObjectTypeNodeLoader(this.context, this.nodeManager).loadAllNodes();
        new ReferenceTypeNodeLoader(this.context, this.nodeManager).loadAllNodes();
        new VariableNodeLoader(this.context, this.nodeManager).loadAllNodes();
        new VariableTypeNodeLoader(this.context, this.nodeManager).loadAllNodes();
    }
}

