/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.db.queryengine.plan.relational.function.BoundSignature;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionId;
import org.apache.iotdb.db.queryengine.plan.relational.function.FunctionKind;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.FunctionNullability;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.ResolvedFunction;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Assignments;
import org.apache.iotdb.db.queryengine.plan.relational.planner.IrExpressionInterpreter;
import org.apache.iotdb.db.queryengine.plan.relational.planner.PlannerContext;
import org.apache.iotdb.db.queryengine.plan.relational.planner.Symbol;
import org.apache.iotdb.db.queryengine.plan.relational.planner.ir.IrUtils;
import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.AggregationNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.SymbolReference;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.Type;

public class SimplifyCountOverConstant
implements Rule<AggregationNode> {
    private static final Capture<ProjectNode> CHILD = Capture.newCapture();
    private static final Pattern<AggregationNode> PATTERN = Patterns.aggregation().with(Patterns.source().matching(Patterns.project().capturedAs(CHILD)));
    private final PlannerContext plannerContext;

    public SimplifyCountOverConstant(PlannerContext plannerContext) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
    }

    @Override
    public Pattern<AggregationNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(AggregationNode parent, Captures captures, Rule.Context context) {
        ProjectNode child = captures.get(CHILD);
        boolean changed = false;
        LinkedHashMap<Symbol, AggregationNode.Aggregation> aggregations = null;
        ResolvedFunction countWildcardFunction = null;
        for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : parent.getAggregations().entrySet()) {
            Symbol symbol = entry.getKey();
            AggregationNode.Aggregation aggregation = entry.getValue();
            if (!this.isCountOverConstant(context, aggregation, child.getAssignments())) continue;
            changed = true;
            if (countWildcardFunction == null) {
                aggregations = new LinkedHashMap<Symbol, AggregationNode.Aggregation>(parent.getAggregations());
                countWildcardFunction = new ResolvedFunction(new BoundSignature("count", (Type)LongType.INT64, Collections.emptyList()), FunctionId.NOOP_FUNCTION_ID, FunctionKind.AGGREGATE, true, FunctionNullability.getAggregationFunctionNullability(1));
            }
            aggregations.put(symbol, new AggregationNode.Aggregation(countWildcardFunction, (List<Expression>)ImmutableList.of(), false, Optional.empty(), Optional.empty(), aggregation.getMask()));
        }
        if (!changed) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(AggregationNode.builderFrom(parent).setSource(child).setAggregations(aggregations).setPreGroupedSymbols((List<Symbol>)ImmutableList.of()).build());
    }

    private boolean isCountOverConstant(Rule.Context context, AggregationNode.Aggregation aggregation, Assignments inputs) {
        BoundSignature signature = aggregation.getResolvedFunction().getSignature();
        if (!signature.getName().equals("count") || signature.getArgumentTypes().size() != 1) {
            return false;
        }
        Expression argument = aggregation.getArguments().get(0);
        if (argument instanceof SymbolReference) {
            argument = inputs.get(Symbol.from(argument));
        }
        if (IrUtils.isEffectivelyLiteral(argument, this.plannerContext, context.getSessionInfo())) {
            Object value = IrExpressionInterpreter.evaluateConstantExpression(argument, this.plannerContext, context.getSessionInfo());
            Verify.verify((!(value instanceof Expression) ? 1 : 0) != 0);
            return value != null;
        }
        return false;
    }
}

