/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.authorizer.OpenIdAuthorizer;
import org.apache.iotdb.commons.auth.entity.ModelType;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.PrivilegeModelType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeUnion;
import org.apache.iotdb.commons.auth.entity.Role;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorTreePlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.rpc.thrift.TAuthizedPatternTreeResp;
import org.apache.iotdb.confignode.rpc.thrift.TListUserInfo;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TRoleResp;
import org.apache.iotdb.confignode.rpc.thrift.TUserResp;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorInfo
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorInfo.class);
    private static final CommonConfig COMMON_CONFIG = CommonDescriptor.getInstance().getConfig();
    private static final String NO_USER_MSG = "No such user : ";
    private IAuthorizer authorizer;
    private ConfigManager configManager;

    public AuthorInfo(ConfigManager configManager) {
        try {
            this.authorizer = BasicAuthorizer.getInstance();
            this.configManager = configManager;
        }
        catch (AuthException e) {
            LOGGER.error("get user or role permissionInfo failed because ", (Throwable)e);
        }
    }

    public TPermissionInfoResp login(String username, String password) {
        boolean status;
        String loginMessage = null;
        TSStatus tsStatus = new TSStatus();
        TPermissionInfoResp result = new TPermissionInfoResp();
        try {
            status = this.authorizer.login(username, password);
            if (status) {
                if (this.authorizer instanceof OpenIdAuthorizer) {
                    username = ((OpenIdAuthorizer)this.authorizer).getIoTDBUserName(username);
                    result = this.getUserPermissionInfo(username, ModelType.ALL);
                    result.getUserInfo().setIsOpenIdUser(true);
                } else {
                    result = this.getUserPermissionInfo(username, ModelType.ALL);
                }
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS, (String)"Login successfully"));
            } else {
                result = AuthUtils.generateEmptyPermissionInfoResp();
            }
        }
        catch (AuthException e) {
            LOGGER.error("meet error while logging in.", (Throwable)e);
            status = false;
            loginMessage = e.getMessage();
        }
        if (!status) {
            tsStatus.setMessage(loginMessage != null ? loginMessage : "Authentication failed.");
            tsStatus.setCode(TSStatusCode.WRONG_LOGIN_PASSWORD.getStatusCode());
            result.setStatus(tsStatus);
        }
        return result;
    }

    public String login4Pipe(String username, String password) {
        return this.authorizer.login4Pipe(username, password);
    }

    public TPermissionInfoResp checkUserPrivileges(String username, PrivilegeUnion union) {
        boolean status;
        TPermissionInfoResp result = new TPermissionInfoResp();
        ArrayList<Integer> failedList = new ArrayList<Integer>();
        try {
            if (union.getModelType() == PrivilegeModelType.TREE) {
                List list = union.getPaths();
                int pos = 0;
                for (PartialPath path : list) {
                    if (!this.authorizer.checkUserPrivileges(username, new PrivilegeUnion(path, union.getPrivilegeType(), union.isGrantOption()))) {
                        failedList.add(pos);
                    }
                    ++pos;
                }
                status = union.isGrantOption() ? failedList.isEmpty() : failedList.size() != list.size();
            } else {
                status = this.authorizer.checkUserPrivileges(username, union);
            }
        }
        catch (AuthException e) {
            status = false;
        }
        try {
            result = this.getUserPermissionInfo(username, ModelType.ALL);
            result.setFailPos(failedList);
            if (status) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
            } else {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.NO_PERMISSION));
            }
        }
        catch (AuthException e) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage()));
        }
        return result;
    }

    public TSStatus authorNonQuery(AuthorPlan authorPlan) {
        if (authorPlan instanceof AuthorTreePlan) {
            return this.authorNonQuery((AuthorTreePlan)authorPlan);
        }
        return this.authorNonQuery((AuthorRelationalPlan)authorPlan);
    }

    public TSStatus authorNonQuery(AuthorTreePlan authorPlan) {
        ConfigPhysicalPlanType authorType = authorPlan.getAuthorType();
        String userName = authorPlan.getUserName();
        String roleName = authorPlan.getRoleName();
        String password = authorPlan.getPassword();
        String newPassword = authorPlan.getNewPassword();
        Set<Integer> permissions = authorPlan.getPermissions();
        boolean grantOpt = authorPlan.getGrantOpt();
        List<PartialPath> nodeNameList = authorPlan.getNodeNameList();
        try {
            switch (authorType) {
                case UpdateUser: {
                    this.authorizer.updateUserPassword(userName, newPassword);
                    break;
                }
                case CreateUser: {
                    this.authorizer.createUser(userName, password);
                    break;
                }
                case CreateUserWithRawPassword: {
                    this.authorizer.createUserWithRawPassword(userName, password);
                    break;
                }
                case CreateRole: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case DropUser: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case DropRole: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case GrantRole: {
                    for (int permission : permissions) {
                        PrivilegeType priv = PrivilegeType.values()[permission];
                        if (priv.isSystemPrivilege()) {
                            this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(priv, grantOpt));
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(path, priv, grantOpt));
                        }
                    }
                    break;
                }
                case GrantUser: {
                    for (int permission : permissions) {
                        PrivilegeType priv = PrivilegeType.values()[permission];
                        if (priv.isSystemPrivilege()) {
                            this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(priv, grantOpt));
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(path, priv, grantOpt));
                        }
                    }
                    break;
                }
                case GrantRoleToUser: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case RevokeUser: {
                    for (int permission : permissions) {
                        PrivilegeType priv = PrivilegeType.values()[permission];
                        if (priv.isSystemPrivilege()) {
                            this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(priv, grantOpt));
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(path, priv, grantOpt));
                        }
                    }
                    break;
                }
                case RevokeRole: {
                    for (int permission : permissions) {
                        PrivilegeType priv = PrivilegeType.values()[permission];
                        if (priv.isSystemPrivilege()) {
                            this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(priv, grantOpt));
                            continue;
                        }
                        for (PartialPath path : nodeNameList) {
                            this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(path, priv, grantOpt));
                        }
                    }
                    break;
                }
                case RevokeRoleFromUser: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                default: {
                    throw new AuthException(TSStatusCode.UNSUPPORTED_AUTH_OPERATION, "unknown type: " + (Object)((Object)authorPlan.getAuthorType()));
                }
            }
        }
        catch (AuthException e) {
            return RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TSStatus authorNonQuery(AuthorRelationalPlan authorPlan) {
        ConfigPhysicalPlanType authorType = authorPlan.getAuthorType();
        String userName = authorPlan.getUserName();
        String roleName = authorPlan.getRoleName();
        String database = authorPlan.getDatabaseName();
        String table = authorPlan.getTableName();
        boolean grantOpt = authorPlan.getGrantOpt();
        Set<Integer> permissions = authorPlan.getPermissions();
        HashSet<PrivilegeType> privileges = new HashSet<PrivilegeType>();
        if (authorType.ordinal() >= ConfigPhysicalPlanType.RGrantUserAny.ordinal() && authorType.ordinal() <= ConfigPhysicalPlanType.RRevokeRoleSysPri.ordinal()) {
            for (int permission : permissions) {
                privileges.add(PrivilegeType.values()[permission]);
            }
        }
        try {
            switch (authorType) {
                case RCreateUser: {
                    this.authorizer.createUser(userName, authorPlan.getPassword());
                    break;
                }
                case RCreateRole: {
                    this.authorizer.createRole(roleName);
                    break;
                }
                case RUpdateUser: {
                    this.authorizer.updateUserPassword(userName, authorPlan.getPassword());
                    break;
                }
                case RDropRole: {
                    this.authorizer.deleteRole(roleName);
                    break;
                }
                case RDropUser: {
                    this.authorizer.deleteUser(userName);
                    break;
                }
                case RGrantUserRole: {
                    this.authorizer.grantRoleToUser(roleName, userName);
                    break;
                }
                case RRevokeUserRole: {
                    this.authorizer.revokeRoleFromUser(roleName, userName);
                    break;
                }
                case RGrantUserAny: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(privilege, grantOpt, true));
                    }
                    break;
                }
                case RGrantRoleAny: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(privilege, grantOpt, true));
                    }
                    break;
                }
                case RGrantUserAll: {
                    if (!database.isEmpty()) {
                        for (PrivilegeType privilege : privileges) {
                            if (!privilege.isRelationalPrivilege()) continue;
                            if (table.isEmpty()) {
                                this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(database, privilege, grantOpt));
                                continue;
                            }
                            this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(database, table, privilege, grantOpt));
                        }
                    } else {
                        for (Iterator<Integer> iterator : PrivilegeType.values()) {
                            if (iterator.forRelationalSys()) {
                                this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(iterator, grantOpt));
                            }
                            if (!iterator.isRelationalPrivilege()) continue;
                            this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(iterator, grantOpt, true));
                        }
                    }
                    break;
                }
                case RGrantRoleAll: {
                    if (!database.isEmpty()) {
                        for (PrivilegeType privilege : privileges) {
                            if (!privilege.isRelationalPrivilege()) continue;
                            if (table.isEmpty()) {
                                this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(database, privilege, grantOpt));
                                continue;
                            }
                            this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(database, table, privilege, grantOpt));
                        }
                    } else {
                        for (Iterator<Integer> iterator : PrivilegeType.values()) {
                            if (iterator.forRelationalSys()) {
                                this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(iterator, grantOpt));
                            }
                            if (!iterator.isRelationalPrivilege()) continue;
                            this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(iterator, grantOpt, true));
                        }
                    }
                    break;
                }
                case RGrantUserDBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(database, privilege, grantOpt));
                    }
                    break;
                }
                case RGrantUserTBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(database, table, privilege, grantOpt));
                    }
                    break;
                }
                case RGrantRoleDBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(database, privilege, grantOpt));
                    }
                    break;
                }
                case RGrantRoleTBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(database, table, privilege, grantOpt));
                    }
                    break;
                }
                case RRevokeUserAny: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(privilege, grantOpt, true));
                    }
                    break;
                }
                case RRevokeRoleAny: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(privilege, grantOpt, true));
                    }
                    break;
                }
                case RRevokeUserAll: {
                    if (!database.isEmpty()) {
                        for (Iterator<Integer> iterator : PrivilegeType.values()) {
                            if (!iterator.isRelationalPrivilege()) continue;
                            if (table.isEmpty()) {
                                this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(database, iterator, grantOpt));
                                continue;
                            }
                            this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(database, table, iterator, grantOpt));
                        }
                        break;
                    }
                    this.authorizer.revokeAllPrivilegeFromUser(userName);
                    break;
                }
                case RRevokeRoleAll: {
                    if (!database.isEmpty()) {
                        for (Iterator<Integer> iterator : PrivilegeType.values()) {
                            if (!iterator.isRelationalPrivilege()) continue;
                            if (table.isEmpty()) {
                                this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(database, iterator, grantOpt));
                                continue;
                            }
                            this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(database, table, iterator, grantOpt));
                        }
                        break;
                    }
                    this.authorizer.revokeAllPrivilegeFromRole(roleName);
                    break;
                }
                case RRevokeUserDBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(database, privilege, grantOpt));
                    }
                    break;
                }
                case RRevokeUserTBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(database, table, privilege, grantOpt));
                    }
                    break;
                }
                case RRevokeRoleDBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(database, privilege, grantOpt));
                    }
                    break;
                }
                case RRevokeRoleTBPriv: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(database, table, privilege, grantOpt));
                    }
                    break;
                }
                case RGrantUserSysPri: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToUser(userName, new PrivilegeUnion(privilege, grantOpt));
                    }
                    break;
                }
                case RGrantRoleSysPri: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.grantPrivilegeToRole(roleName, new PrivilegeUnion(privilege, grantOpt));
                    }
                    break;
                }
                case RRevokeUserSysPri: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromUser(userName, new PrivilegeUnion(privilege, grantOpt));
                    }
                    break;
                }
                case RRevokeRoleSysPri: {
                    for (PrivilegeType privilege : privileges) {
                        this.authorizer.revokePrivilegeFromRole(roleName, new PrivilegeUnion(privilege, grantOpt));
                    }
                    break;
                }
                default: {
                    throw new AuthException(TSStatusCode.ILLEGAL_PARAMETER, "not support");
                }
            }
        }
        catch (AuthException e) {
            return RpcUtils.getStatus((TSStatusCode)e.getCode(), (String)e.getMessage());
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public PermissionInfoResp executeListUsers(AuthorPlan plan) throws AuthException {
        ArrayList<TListUserInfo> userInfoList;
        ArrayList<String> userList;
        PermissionInfoResp result = new PermissionInfoResp();
        boolean hasPermissionToListOtherUsers = plan.getUserName().isEmpty();
        if (!hasPermissionToListOtherUsers) {
            userList = new ArrayList<String>(1);
            userList.add(plan.getUserName());
            User user = this.authorizer.getUser(plan.getUserName());
            userInfoList = new ArrayList<TListUserInfo>(1);
            userInfoList.add(user.convertToListUserInfo());
        } else {
            userList = this.authorizer.listAllUsers();
            userInfoList = this.authorizer.listAllUsersInfo();
        }
        if (!plan.getRoleName().isEmpty()) {
            Role role = this.authorizer.getRole(plan.getRoleName());
            if (role == null) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.ROLE_NOT_EXIST, (String)("No such role : " + plan.getRoleName())));
                return result;
            }
            Iterator itr = userList.iterator();
            HashSet<String> toRemove = new HashSet<String>();
            while (itr.hasNext()) {
                String userName = (String)itr.next();
                User userObj = this.authorizer.getUser(userName);
                if (userObj != null && userObj.hasRole(plan.getRoleName())) continue;
                itr.remove();
                toRemove.add(userName);
            }
            userInfoList.removeIf(info -> toRemove.contains(info.username));
        }
        result.setTag("User");
        result.setMemberInfo(userList);
        result.setUsersInfo(userInfoList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public PermissionInfoResp executeListRoles(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        ArrayList<String> permissionInfo = new ArrayList<String>();
        ArrayList<String> roleList = new ArrayList<String>();
        if (plan.getUserName().isEmpty()) {
            roleList.addAll(this.authorizer.listAllRoles());
        } else {
            User user = this.authorizer.getUser(plan.getUserName());
            if (user == null) {
                result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + plan.getUserName())));
                result.setMemberInfo(permissionInfo);
                return result;
            }
            roleList.addAll(user.getRoleSet());
        }
        result.setTag("Role");
        result.setMemberInfo(roleList);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public PermissionInfoResp executeListRolePrivileges(AuthorPlan plan) throws AuthException {
        boolean isTreePlan = plan instanceof AuthorTreePlan;
        PermissionInfoResp result = new PermissionInfoResp();
        ArrayList<String> permissionInfo = new ArrayList<String>();
        Role role = this.authorizer.getRole(plan.getRoleName());
        if (role == null) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.ROLE_NOT_EXIST, (String)("No such role : " + plan.getRoleName())));
            result.setMemberInfo(permissionInfo);
            return result;
        }
        TPermissionInfoResp resp = new TPermissionInfoResp();
        TRoleResp roleResp = role.getRoleInfo(isTreePlan ? ModelType.TREE : ModelType.RELATIONAL);
        HashMap<String, TRoleResp> roleInfo = new HashMap<String, TRoleResp>();
        roleInfo.put(role.getName(), roleResp);
        resp.setRoleInfo(roleInfo);
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTag("Privileges");
        result.setPermissionInfoResp(resp);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setMemberInfo(permissionInfo);
        return result;
    }

    public PermissionInfoResp executeListUserPrivileges(AuthorPlan plan) throws AuthException {
        PermissionInfoResp result = new PermissionInfoResp();
        boolean isTreePlan = plan instanceof AuthorTreePlan;
        User user = this.authorizer.getUser(plan.getUserName());
        if (user == null) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + plan.getUserName())));
            return result;
        }
        TPermissionInfoResp resp = this.getUserPermissionInfo(plan.getUserName(), isTreePlan ? ModelType.TREE : ModelType.RELATIONAL);
        resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        result.setTag("Privileges");
        result.setPermissionInfoResp(resp);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public TAuthizedPatternTreeResp generateAuthorizedPTree(String username, int permission) throws AuthException {
        TAuthizedPatternTreeResp resp = new TAuthizedPatternTreeResp();
        User user = this.authorizer.getUser(username);
        PrivilegeType type = PrivilegeType.values()[permission];
        PathPatternTree pPtree = new PathPatternTree();
        if (user == null) {
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_EXIST, (String)(NO_USER_MSG + username)));
            resp.setUsername(username);
            resp.setPrivilegeId(permission);
            return resp;
        }
        for (PathPrivilege path : user.getPathPrivilegeList()) {
            if (!path.checkPrivilege(type)) continue;
            pPtree.appendPathPattern(path.getPath());
        }
        for (String rolename : user.getRoleSet()) {
            Role role = this.authorizer.getRole(rolename);
            if (role == null) continue;
            for (PathPrivilege path : role.getPathPrivilegeList()) {
                if (!path.checkPrivilege(type)) continue;
                pPtree.appendPathPattern(path.getPath());
            }
        }
        pPtree.constructTree();
        resp.setUsername(username);
        resp.setPrivilegeId(permission);
        resp.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            pPtree.serialize(dataOutputStream);
        }
        catch (IOException e) {
            resp.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.EXECUTE_STATEMENT_ERROR, (String)"Get error when serialize pattern tree."));
            return resp;
        }
        resp.setPathPatternTree(ByteBuffer.wrap(byteArrayOutputStream.toByteArray()));
        resp.setPermissionInfo(this.getUserPermissionInfo(username, ModelType.ALL));
        return resp;
    }

    public TPermissionInfoResp checkRoleOfUser(String username, String rolename) throws AuthException {
        User user = this.authorizer.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format("No such user : %s", username));
        }
        TPermissionInfoResp result = this.getUserPermissionInfo(username, ModelType.ALL);
        if (user.getRoleSet().contains(rolename)) {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        } else {
            result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.USER_NOT_HAS_ROLE));
        }
        return result;
    }

    public TPermissionInfoResp getUser(String username) throws AuthException {
        User user = this.authorizer.getUser(username);
        if (user == null) {
            throw new AuthException(TSStatusCode.USER_NOT_EXIST, String.format("No such user : %s", username));
        }
        TPermissionInfoResp result = this.getUserPermissionInfo(username, ModelType.ALL);
        result.setStatus(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS));
        return result;
    }

    public String getUserName(long userId) throws AuthException {
        return this.authorizer.getUser(userId).getName();
    }

    public boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return this.authorizer.processTakeSnapshot(snapshotDir);
    }

    public void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        this.authorizer.processLoadSnapshot(snapshotDir);
    }

    @TestOnly
    public void clear() throws AuthException {
        File roleFolder;
        File userFolder = new File(COMMON_CONFIG.getUserFolder());
        if (userFolder.exists()) {
            FileUtils.deleteFileOrDirectory((File)userFolder);
        }
        if ((roleFolder = new File(COMMON_CONFIG.getRoleFolder())).exists()) {
            FileUtils.deleteFileOrDirectory((File)roleFolder);
        }
        this.authorizer.reset();
    }

    public TPermissionInfoResp getUserPermissionInfo(String username, ModelType type) throws AuthException {
        TPermissionInfoResp result = new TPermissionInfoResp();
        User user = this.authorizer.getUser(username);
        if (user == null) {
            return AuthUtils.generateEmptyPermissionInfoResp();
        }
        TUserResp tUserResp = user.getUserInfo(type);
        if (!user.getRoleSet().isEmpty()) {
            for (String roleName : user.getRoleSet()) {
                Role role = this.authorizer.getRole(roleName);
                TRoleResp roleResp = role.getRoleInfo(type);
                result.putToRoleInfo(roleName, roleResp);
            }
        } else {
            result.setRoleInfo(new HashMap());
        }
        result.setUserInfo(tUserResp);
        result.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        return result;
    }
}

